/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.util;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.model.HTTPMethod;
import org.mule.connectivity.model.operation.Operation;
import org.mule.connectivity.predicate.OperationNamePredicate;
import org.raml.v2.api.model.v10.declarations.AnnotationRef;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.system.types.AnnotableStringType;
import org.raml.v2.internal.utils.Inflector;

public class ParserUtils {
    private static final List<String> reservedJavaWords = Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while");
    private static final List<String> reservedProcessorParameterNames = Arrays.asList("name", "friendlyName");

    private ParserUtils() {
    }

    public static String getMethodDescription(Method method) {
        String description = null;
        if (method.description() != null) {
            description = method.description().value();
        }
        if (method.resource() != null && method.resource().description() != null) {
            description = method.resource().description().value();
        }
        return StringUtils.trimToNull((String)description);
    }

    public static String getMethodDisplayName(Method method) {
        String displayName = null;
        if (!method.displayName().value().equals(method.method())) {
            displayName = method.displayName().value();
        }
        return StringUtils.trimToNull(displayName);
    }

    public static String getCanonicalOperationName(Method method, Operation operation) {
        String annotatedOperationName = ParserUtils.getAnnotatedOperationName(method);
        if (annotatedOperationName != null) {
            return ParserUtils.getCanonicalNameFromFriendlyName(annotatedOperationName);
        }
        if (operation.getFriendlyName() != null) {
            return ParserUtils.getCanonicalNameFromFriendlyName(operation.getFriendlyName());
        }
        return ParserUtils.buildCanonicalOperationName(method);
    }

    private static String buildCanonicalOperationName(Method method) {
        HTTPMethod httpMethod = HTTPMethod.fromMethod(method);
        StringBuilder operationNameBuilder = new StringBuilder().append(httpMethod.getVerbName());
        String resourceName = null;
        Boolean isElement = null;
        ArrayList<String> parameters = new ArrayList<String>();
        String remainingPath = method.resource().resourcePath();
        do {
            String pathSegment = remainingPath.substring(remainingPath.lastIndexOf("/") + 1);
            boolean hasParameter = ParserUtils.hasUriParameter(pathSegment);
            if (isElement == null) {
                isElement = hasParameter;
            }
            if (hasParameter) {
                parameters.add(ParserUtils.getCapUnderscoreName(pathSegment));
                continue;
            }
            if (resourceName != null) continue;
            resourceName = pathSegment;
        } while (StringUtils.isNotBlank((CharSequence)(remainingPath = remainingPath.substring(0, remainingPath.lastIndexOf("/")))) && !remainingPath.equals("/"));
        if (StringUtils.isNotBlank((CharSequence)resourceName)) {
            resourceName = isElement != false || httpMethod.isAlwaysSingular() ? Inflector.singularize((String)resourceName) : Inflector.pluralize((String)resourceName);
            operationNameBuilder.append("_").append(ParserUtils.getCapUnderscoreName(resourceName));
        }
        if (!parameters.isEmpty()) {
            Collections.reverse(parameters);
            operationNameBuilder.append("_BY_").append(StringUtils.join(parameters, (String)"_"));
        }
        return operationNameBuilder.toString();
    }

    public static String removeUnwantedCharacters(String name) {
        if (name == null) {
            return null;
        }
        return name.replaceAll("[^a-zA-Z0-9_-]", "");
    }

    public static String removePackageUnwantedCharacters(String name) {
        if (name == null) {
            return null;
        }
        return name.replaceAll("[^a-zA-Z0-9]", "").toLowerCase();
    }

    public static String getCapUnderscoreName(String name) {
        return ParserUtils.splitCapsWithUnderscores(ParserUtils.getSanitizedOperationName(name)).toUpperCase();
    }

    public static String getSanitizedOperationName(String name) {
        name = name.replaceAll("-", "_");
        if ((name = name.replaceAll("[^a-zA-Z0-9_-]", "")).startsWith("_")) {
            name = name.replaceFirst("_", "");
        }
        return name;
    }

    public static String getXmlName(String name) {
        return ParserUtils.splitCapsWithHypens(ParserUtils.getXmlSanitizedName(name)).toLowerCase();
    }

    public static String splitCapsWithUnderscores(String name) {
        return ParserUtils.splitCaps(name, "_");
    }

    public static String splitCapsWithHypens(String name) {
        return ParserUtils.splitCaps(name, "-");
    }

    public static String splitCaps(String name, String split) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (Character.isUpperCase(name.charAt(i)) && i > 0 && Character.isLowerCase(name.charAt(i - 1))) {
                builder.append(split);
            } else if (i > 0 && name.charAt(i) == '_' && i + 1 < name.length() && Character.isAlphabetic(name.charAt(i + 1))) {
                builder.append(split);
                continue;
            }
            builder.append(name.charAt(i));
        }
        return builder.toString();
    }

    public static String getXmlSanitizedName(String name) {
        if ((name = ParserUtils.removeUnwantedCharacters(name)).toLowerCase().startsWith("xml") || Character.isDigit(name.charAt(0))) {
            name = "_" + name;
        }
        if (name.startsWith("-")) {
            name = name.replaceFirst("-", "_");
        }
        return name;
    }

    public static String getJavaName(String operationName) {
        return Inflector.lowercamelcase((String)ParserUtils.removeUnwantedCharacters(operationName));
    }

    private static String getCanonicalNameFromFriendlyName(String friendlyName) {
        friendlyName = friendlyName.replace(" ", "_");
        return ParserUtils.removeUnwantedCharacters(friendlyName.toUpperCase());
    }

    private static String getParameterName(String uriValue) {
        String cleanParameterName = uriValue.replace("{", "").replace("}", "");
        return Inflector.upperunderscorecase((String)cleanParameterName);
    }

    private static boolean hasUriParameter(String uriValue) {
        return uriValue.matches("\\{.*\\}");
    }

    private static String getAnnotatedOperationName(Method method) {
        AnnotationRef opNameAnnotation = (AnnotationRef)FluentIterable.from((Iterable)Iterables.filter((Iterable)method.annotations(), (Predicate)new OperationNamePredicate())).first().orNull();
        if (opNameAnnotation == null) {
            return null;
        }
        return (String)opNameAnnotation.structuredValue().value();
    }

    public static String getValueFromAnnotableString(AnnotableStringType annotableString) {
        return annotableString == null ? null : annotableString.value();
    }

    public static String removeSpaces(String string) {
        return string == null ? null : string.replace(" ", "");
    }

    public static String removeHyphens(String string) {
        return string == null ? null : string.replace("-", "");
    }

    public static String removeSpacesAndHyphens(String string) {
        return ParserUtils.removeHyphens(ParserUtils.removeSpaces(string));
    }

    public static boolean isReservedJavaWord(String word) {
        return reservedJavaWords.contains(word);
    }

    public static boolean isReservedProcessorVariableName(String word) {
        return reservedProcessorParameterNames.contains(word);
    }

    public static boolean isValidDevKitParameterName(String word) {
        return !ParserUtils.isReservedJavaWord(word) && !ParserUtils.isReservedProcessorVariableName(word);
    }
}

