/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.exception;

import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.internal.exception.ExceptionMapping;

public class ExceptionMapper {
    private Set<ExceptionMapping> exceptionMappings = new TreeSet<ExceptionMapping>();

    private ExceptionMapper(Set<ExceptionMapping> exceptionMappings) {
        this.exceptionMappings = exceptionMappings;
    }

    public Optional<ErrorType> resolveErrorType(Class<? extends Throwable> exceptionType) {
        return this.exceptionMappings.stream().filter(exceptionMapping -> exceptionMapping.matches(exceptionType)).findFirst().map(ExceptionMapping::getErrorType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Set<ExceptionMapping> exceptionMappings = new TreeSet<ExceptionMapping>();

        private Builder() {
        }

        public Builder addExceptionMapping(Class<? extends Throwable> exceptionType, ErrorType errorType) {
            if (!this.exceptionMappings.add(new ExceptionMapping(exceptionType, errorType))) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Cannot build an %s with a repeated mapping for exception %s", ExceptionMapper.class.getName(), exceptionType.getClass().getName())));
            }
            return this;
        }

        public ExceptionMapper build() {
            return new ExceptionMapper(this.exceptionMappings);
        }
    }
}

