/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeConnectionManager
implements ConnectionManager,
Lifecycle,
ConnectionManagerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeConnectionManager.class);
    private final ConnectionManagerAdapter childConnectionManager;
    private final ConnectionManagerAdapter parentConnectionManager;

    public CompositeConnectionManager(ConnectionManagerAdapter childConnectionManager, ConnectionManagerAdapter parentConnectionManager) {
        Preconditions.checkNotNull(childConnectionManager, "'childConnectionManager' can't be null");
        Preconditions.checkNotNull(parentConnectionManager, "'parentConnectionManager' can't be null");
        this.childConnectionManager = childConnectionManager;
        this.parentConnectionManager = parentConnectionManager;
    }

    @Override
    public <C> void bind(Object config, ConnectionProvider<C> connectionProvider) {
        this.childConnectionManager.bind(config, connectionProvider);
    }

    @Override
    public boolean hasBinding(Object config) {
        return this.childConnectionManager.hasBinding(config) || this.parentConnectionManager.hasBinding(config);
    }

    @Override
    public void unbind(Object config) {
        if (this.childConnectionManager.hasBinding(config)) {
            this.childConnectionManager.unbind(config);
        } else if (this.parentConnectionManager.hasBinding(config)) {
            this.parentConnectionManager.unbind(config);
        }
    }

    @Override
    public <C> ConnectionHandler<C> getConnection(Object config) throws ConnectionException {
        return this.childConnectionManager.hasBinding(config) ? this.childConnectionManager.getConnection(config) : this.parentConnectionManager.getConnection(config);
    }

    @Override
    public <C> ConnectionValidationResult testConnectivity(ConnectionProvider<C> connectionProvider) {
        return this.childConnectionManager.testConnectivity(connectionProvider);
    }

    @Override
    public ConnectionValidationResult testConnectivity(ConfigurationInstance configurationInstance) throws IllegalArgumentException {
        Object value = configurationInstance.getValue();
        if (this.childConnectionManager.hasBinding(value)) {
            return this.childConnectionManager.testConnectivity(configurationInstance);
        }
        return this.parentConnectionManager.testConnectivity(configurationInstance);
    }

    @Override
    public <C> ConnectionValidationResult testConnectivity(C connection, ConnectionHandler<C> connectionHandler) {
        return this.childConnectionManager.testConnectivity(connection, connectionHandler);
    }

    @Override
    public <C> RetryPolicyTemplate getRetryTemplateFor(ConnectionProvider<C> connectionProvider) {
        return this.childConnectionManager.getRetryTemplateFor(connectionProvider);
    }

    @Override
    public <C> ReconnectionConfig getReconnectionConfigFor(ConnectionProvider<C> connectionProvider) {
        return this.childConnectionManager.getReconnectionConfigFor(connectionProvider);
    }

    @Override
    public PoolingProfile getDefaultPoolingProfile() {
        return this.childConnectionManager.getDefaultPoolingProfile();
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.childConnectionManager, LOGGER);
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.childConnectionManager);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.childConnectionManager);
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.childConnectionManager);
    }
}

