/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.object;

import java.util.NoSuchElementException;
import java.util.Optional;
import org.mule.runtime.core.api.streaming.iterator.StreamingIterator;
import org.mule.runtime.core.internal.streaming.AbstractStreamingBuffer;
import org.mule.runtime.core.internal.streaming.object.Bucket;
import org.mule.runtime.core.internal.streaming.object.ObjectStreamBuffer;
import org.mule.runtime.core.internal.streaming.object.Position;

public abstract class AbstractObjectStreamBuffer<T>
extends AbstractStreamingBuffer
implements ObjectStreamBuffer<T> {
    private final StreamingIterator<T> stream;
    private Bucket<T> currentBucket = new Bucket(0, 100);
    private Position currentPosition;
    private Position maxPosition = null;
    private int instancesCount = 0;

    public AbstractObjectStreamBuffer(StreamingIterator<T> stream) {
        this.stream = stream;
    }

    @Override
    public final void initialise() {
        this.currentPosition = new Position(0, -1);
        int size = this.getSize();
        if (size > 0) {
            this.setMaxPosition(this.toPosition(size - 1));
        }
        this.initialize(Optional.ofNullable(this.maxPosition), this.currentBucket);
    }

    protected abstract void initialize(Optional<Position> var1, Bucket<T> var2);

    @Override
    public Optional<Bucket<T>> getBucketFor(Position position) {
        this.checkNotClosed();
        if (this.maxPosition != null && this.maxPosition.compareTo(position) < 0) {
            throw new NoSuchElementException();
        }
        return this.withReadLock(releaser -> {
            Optional<Bucket<T>> bucket = this.getPresentBucket(position);
            if (bucket.isPresent()) {
                return this.forwarding(bucket);
            }
            releaser.release();
            return this.fetch(position);
        });
    }

    @Override
    public int getSize() {
        return this.stream.getSize();
    }

    @Override
    public final boolean hasNext(long i) {
        if (this.closed.get()) {
            return false;
        }
        Position position = this.toPosition(i);
        return this.withReadLock(releaser -> {
            if (this.maxPosition != null) {
                return position.compareTo(this.maxPosition) < 1;
            }
            if (position.compareTo(this.currentPosition) < 1) {
                return true;
            }
            releaser.release();
            try {
                return this.fetch(position).isPresent();
            }
            catch (NoSuchElementException e) {
                return false;
            }
        });
    }

    private Optional<Bucket<T>> fetch(Position position) {
        return this.withWriteLock(() -> {
            Optional<Bucket<Bucket>> presentBucket = this.getPresentBucket(position);
            if (presentBucket.filter(bucket -> bucket.contains(position)).isPresent()) {
                return presentBucket;
            }
            while (this.currentPosition.compareTo(position) < 0) {
                if (!this.stream.hasNext()) {
                    this.maxPosition = this.currentPosition;
                    return Optional.empty();
                }
                Object item = this.stream.next();
                if (this.currentBucket.add(item)) {
                    this.currentPosition = this.currentPosition.advanceItem();
                } else {
                    this.setCurrentBucket(this.onBucketOverflow(this.currentBucket));
                    this.currentBucket.add(item);
                    this.currentPosition = this.currentPosition.advanceBucket();
                }
                ++this.instancesCount;
                this.validateMaxBufferSizeNotExceeded(this.instancesCount);
            }
            return Optional.of(this.currentBucket);
        });
    }

    protected abstract void validateMaxBufferSizeNotExceeded(int var1);

    protected abstract Bucket<T> onBucketOverflow(Bucket<T> var1);

    @Override
    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.writeLock.lock();
            try {
                this.doClose();
            }
            finally {
                this.closeSafely(this.stream::close);
                this.setCurrentBucket(null);
                this.writeLock.unlock();
            }
        }
    }

    protected abstract void doClose();

    protected abstract Optional<Bucket<T>> getPresentBucket(Position var1);

    private Optional<Bucket<T>> forwarding(Optional<Bucket<T>> presentBucket) {
        return presentBucket.map(b -> new ForwardingBucket((Bucket)b));
    }

    protected Bucket<T> getCurrentBucket() {
        return this.currentBucket;
    }

    protected void setCurrentBucket(Bucket<T> bucket) {
        this.currentBucket = bucket;
    }

    protected void setMaxPosition(Position maxPosition) {
        this.maxPosition = maxPosition;
    }

    private class ForwardingBucket<T>
    extends Bucket<T> {
        private Bucket<T> delegate;

        private ForwardingBucket(Bucket<T> delegate) {
            super(delegate.getIndex(), 0);
            this.delegate = delegate;
        }

        @Override
        public Optional<T> get(int index) {
            return (Optional)AbstractObjectStreamBuffer.this.withReadLock(releaser -> {
                Optional<T> item = this.delegate.get(index);
                if (item.isPresent()) {
                    return item;
                }
                Position position = new Position(this.delegate.getIndex(), index);
                releaser.release();
                this.delegate = (Bucket)AbstractObjectStreamBuffer.this.fetch(position).orElseThrow(NoSuchElementException::new);
                return (Optional)AbstractObjectStreamBuffer.this.withReadLock(r2 -> this.delegate.get(index));
            });
        }

        @Override
        public boolean contains(Position position) {
            return this.delegate.contains(position);
        }

        @Override
        public int getIndex() {
            return this.delegate.getIndex();
        }
    }
}

