/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.persistence.JsonMetadataTypeLoader;
import org.mule.metadata.persistence.JsonMetadataTypeWriter;
import org.mule.metadata.persistence.SerializationContext;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.model.ImmutableExtensionModel;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.HierarchyClassMap;
import org.mule.runtime.extension.internal.persistence.ErrorModelSerializerDelegate;

public final class ExtensionModelTypeAdapter
extends TypeAdapter<ExtensionModel> {
    private static final String CONFIGURATIONS = "configurations";
    private static final String OPERATIONS = "operations";
    private static final String FUNCTIONS = "functions";
    private static final String CONSTRUCTS = "constructs";
    private static final String CONNECTION_PROVIDERS = "connectionProviders";
    private static final String MESSAGE_SOURCES = "messageSources";
    private static final String MODEL_PROPERTIES = "modelProperties";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String VERSION = "version";
    private static final String VENDOR = "vendor";
    private static final String CATEGORY = "category";
    private static final String TYPES = "types";
    private static final String RESOURCES = "resources";
    private static final String PRIVILEGED_PACKAGES = "privilegedPackages";
    private static final String PRIVILEGED_ARTIFACTS = "privilegedArtifacts";
    private static final String XML_DSL = "xmlDsl";
    private static final String SUB_TYPES = "subTypes";
    private static final String EXTERNAL_LIBRARIES = "externalLibraries";
    private static final String DISPLAY_MODEL = "displayModel";
    private static final String IMPORTED_TYPES = "importedTypes";
    static final String ERRORS = "errors";
    private final Gson gsonDelegate;
    private final JsonMetadataTypeLoader typeLoader = new JsonMetadataTypeLoader();
    private final JsonMetadataTypeWriter typeWriter = new JsonMetadataTypeWriter();
    private final SerializationContext serializationContext;
    private final ErrorModelSerializerDelegate errorModelDelegate;

    public ExtensionModelTypeAdapter(Gson gsonDelegate, SerializationContext serializationContext, Map<String, ErrorModel> errorModelMap) {
        this.gsonDelegate = gsonDelegate;
        this.serializationContext = serializationContext;
        this.errorModelDelegate = new ErrorModelSerializerDelegate(errorModelMap);
    }

    public void write(JsonWriter out, ExtensionModel model) throws IOException {
        out.beginObject();
        out.name(NAME).value(model.getName());
        out.name(DESCRIPTION).value(model.getDescription());
        out.name(VERSION).value(model.getVersion());
        out.name(VENDOR).value(model.getVendor());
        this.writeWithDelegate(model.getCategory(), CATEGORY, out, new TypeToken<Category>(){});
        this.writeWithDelegate(model.getXmlDslModel(), XML_DSL, out, new TypeToken<XmlDslModel>(){});
        this.writeWithDelegate(model.getResources(), RESOURCES, out, new TypeToken<Set<String>>(){});
        this.writeWithDelegate(model.getSubTypes(), SUB_TYPES, out, new TypeToken<Set<SubTypesModel>>(){});
        this.writeWithDelegate(model.getPrivilegedPackages(), PRIVILEGED_PACKAGES, out, new TypeToken<Set<String>>(){});
        this.writeWithDelegate(model.getPrivilegedArtifacts(), PRIVILEGED_ARTIFACTS, out, new TypeToken<Set<String>>(){});
        this.writeWithDelegate(model.getExternalLibraryModels(), EXTERNAL_LIBRARIES, out, new TypeToken<Set<ExternalLibraryModel>>(){});
        this.writeImportedTypes(out, model.getImportedTypes());
        this.writeWithDelegate(model.getDisplayModel().orElse(null), DISPLAY_MODEL, out, new TypeToken<DisplayModel>(){});
        this.writeWithDelegate(model.getConfigurationModels(), CONFIGURATIONS, out, new TypeToken<List<ConfigurationModel>>(){});
        this.writeWithDelegate(model.getOperationModels(), OPERATIONS, out, new TypeToken<List<OperationModel>>(){});
        this.writeWithDelegate(model.getFunctionModels(), FUNCTIONS, out, new TypeToken<List<FunctionModel>>(){});
        this.writeWithDelegate(model.getConstructModels(), CONSTRUCTS, out, new TypeToken<List<ConstructModel>>(){});
        this.writeWithDelegate(model.getConnectionProviders(), CONNECTION_PROVIDERS, out, new TypeToken<List<ConnectionProviderModel>>(){});
        this.writeWithDelegate(model.getSourceModels(), MESSAGE_SOURCES, out, new TypeToken<List<SourceModel>>(){});
        this.errorModelDelegate.writeErrors(model.getErrorModels(), out);
        this.writeExtensionLevelModelProperties(out, model);
        this.writeTypes(TYPES, out, model.getTypes());
        out.endObject();
    }

    public ExtensionModel read(JsonReader in) throws IOException {
        JsonObject json = new JsonParser().parse(in).getAsJsonObject();
        Set<ObjectType> types = this.parseTypes(TYPES, json);
        JsonArray errors = json.get(ERRORS).getAsJsonArray();
        Map<String, ErrorModel> parsedErrors = this.errorModelDelegate.parseErrors(errors);
        Set<ImportedTypeModel> importedTypes = this.parseImportedTypes(json);
        Set<String> resources = this.parseWithDelegate(json, RESOURCES, new TypeToken<Set<String>>(){});
        Set<SubTypesModel> subTypes = this.parseWithDelegate(json, SUB_TYPES, new TypeToken<Set<SubTypesModel>>(){});
        Set<String> privilegedPackages = this.parseWithDelegate(json, PRIVILEGED_PACKAGES, new TypeToken<Set<String>>(){});
        Set<String> privilegedArtifacts = this.parseWithDelegate(json, PRIVILEGED_ARTIFACTS, new TypeToken<Set<String>>(){});
        Set<ExternalLibraryModel> externalLibraries = this.parseWithDelegate(json, EXTERNAL_LIBRARIES, new TypeToken<Set<ExternalLibraryModel>>(){});
        List<ConfigurationModel> configs = this.parseWithDelegate(json, CONFIGURATIONS, new TypeToken<List<ConfigurationModel>>(){});
        List<OperationModel> operations = this.parseWithDelegate(json, OPERATIONS, new TypeToken<List<OperationModel>>(){});
        List<ConnectionProviderModel> providers = this.parseWithDelegate(json, CONNECTION_PROVIDERS, new TypeToken<List<ConnectionProviderModel>>(){});
        List<SourceModel> sources = this.parseWithDelegate(json, MESSAGE_SOURCES, new TypeToken<List<SourceModel>>(){});
        List<FunctionModel> functions = this.parseWithDelegate(json, FUNCTIONS, new TypeToken<List<FunctionModel>>(){});
        List<ConstructModel> constructs = this.parseWithDelegate(json, CONSTRUCTS, new TypeToken<List<ConstructModel>>(){});
        return new ImmutableExtensionModel(json.get(NAME).getAsString(), json.get(DESCRIPTION).getAsString(), json.get(VERSION).getAsString(), json.get(VENDOR).getAsString(), (Category)((Object)this.gsonDelegate.fromJson(json.get(CATEGORY), Category.class)), configs, operations, providers, sources, functions, constructs, (DisplayModel)this.gsonDelegate.fromJson(json.get(DISPLAY_MODEL), DisplayModel.class), (XmlDslModel)this.gsonDelegate.fromJson(json.get(XML_DSL), XmlDslModel.class), subTypes, types, resources, importedTypes, new HashSet<ErrorModel>(parsedErrors.values()), externalLibraries, privilegedPackages, privilegedArtifacts, this.parseExtensionLevelModelProperties(json));
    }

    private <T> T parseWithDelegate(JsonObject json, String elementName, TypeToken<T> typeToken) {
        JsonElement element = json.get(elementName);
        if (element != null) {
            return (T)this.gsonDelegate.fromJson(element, typeToken.getType());
        }
        return null;
    }

    private <T> void writeWithDelegate(T value, String elementName, JsonWriter out, TypeToken<T> typeToken) throws IOException {
        out.name(elementName);
        this.gsonDelegate.toJson(value, typeToken.getType(), out);
    }

    private Set<ObjectType> parseTypes(String label, JsonObject json) {
        LinkedHashSet<ObjectType> types = new LinkedHashSet<ObjectType>();
        JsonArray typesArray = json.get(label).getAsJsonArray();
        if (typesArray == null) {
            return Collections.emptySet();
        }
        typesArray.forEach(typeElement -> this.typeLoader.load((JsonElement)typeElement).ifPresent(type -> {
            if (!(type instanceof ObjectType)) {
                throw new IllegalArgumentException(String.format("Was expecting an object type but %s was found instead", type.getClass().getSimpleName()));
            }
            ExtensionMetadataTypeUtils.getId(type).orElseThrow(() -> new IllegalArgumentException("Invalid json element found in 'types', only ObjectTypes with a 'typeId' can be part of the 'types' catalog"));
            ObjectType objectType = (ObjectType)type;
            this.serializationContext.registerObjectType(objectType);
            types.add(objectType);
        }));
        return types;
    }

    private Set<ImportedTypeModel> parseImportedTypes(JsonObject json) {
        return this.parseTypes(IMPORTED_TYPES, json).stream().map(ImportedTypeModel::new).collect(Collectors.toSet());
    }

    private void writeTypes(String label, JsonWriter out, Set<ObjectType> additionalTypes) throws IOException {
        out.name(label);
        out.beginArray();
        LinkedHashSet<ObjectType> objectTypes = new LinkedHashSet<ObjectType>();
        objectTypes.addAll(additionalTypes);
        for (ObjectType type : objectTypes) {
            this.typeWriter.write(type, out);
        }
        out.endArray();
    }

    private void writeImportedTypes(JsonWriter out, Set<ImportedTypeModel> importedTypeModels) throws IOException {
        this.writeTypes(IMPORTED_TYPES, out, importedTypeModels.stream().map(ImportedTypeModel::getImportedType).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    private void writeExtensionLevelModelProperties(JsonWriter out, ExtensionModel model) throws IOException {
        out.name(MODEL_PROPERTIES);
        HierarchyClassMap properties = new HierarchyClassMap();
        model.getModelProperties().forEach(p -> properties.put(p.getClass(), p));
        this.gsonDelegate.toJson(properties, new TypeToken<HierarchyClassMap<ModelProperty>>(){}.getType(), out);
    }

    private Set<ModelProperty> parseExtensionLevelModelProperties(JsonObject json) {
        Map properties = (Map)this.gsonDelegate.fromJson(json.get(MODEL_PROPERTIES), new TypeToken<Map<Class<? extends ModelProperty>, ModelProperty>>(){}.getType());
        return new LinkedHashSet<ModelProperty>(properties.values());
    }
}

