/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Arrays;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.extension.api.annotation.Export;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;

public final class JavaExportedTypesDeclarationEnricher
extends AbstractAnnotatedDeclarationEnricher {
    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
        Export exportAnnotation = this.extractAnnotation((BaseDeclaration<? extends BaseDeclaration>)extensionLoadingContext.getExtensionDeclarer().getDeclaration(), Export.class);
        if (exportAnnotation != null) {
            ExtensionDeclarer declarer = extensionLoadingContext.getExtensionDeclarer();
            Arrays.stream(exportAnnotation.classes()).map(typeLoader::load).forEach(type -> this.registerType(declarer, (MetadataType)type));
            Arrays.stream(exportAnnotation.resources()).forEach(declarer::withResource);
        }
    }

    private void registerType(final ExtensionDeclarer declarer, MetadataType type) {
        type.accept(new MetadataTypeVisitor(){

            @Override
            public void visitObject(ObjectType objectType) {
                if (objectType.isOpen()) {
                    objectType.getOpenRestriction().get().accept(this);
                } else {
                    declarer.withType(objectType);
                }
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept(this);
            }

            @Override
            public void visitIntersection(IntersectionType intersectionType) {
                intersectionType.getTypes().forEach(type -> type.accept(this));
            }

            @Override
            public void visitUnion(UnionType unionType) {
                unionType.getTypes().forEach(type -> type.accept(this));
            }

            @Override
            public void visitObjectField(ObjectFieldType objectFieldType) {
                objectFieldType.getValue().accept(this);
            }
        });
    }
}

