/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.lang.reflect.Field;
import java.util.List;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class ComponentLocationModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel model, final ProblemsReporter problemsReporter) {
        new IdempotentExtensionWalker(){

            @Override
            protected void onSource(SourceModel model) {
                model.getModelProperty(ImplementingTypeModelProperty.class).map(ImplementingTypeModelProperty::getType).ifPresent(sourceType -> {
                    List<Field> fields = IntrospectionUtils.getFieldsOfType(sourceType, ComponentLocation.class);
                    if (fields.size() > 1) {
                        problemsReporter.addError(new Problem(model, String.format("Source of type '%s' has %d fields of type '%s'. Only one is allowed", sourceType.getName(), fields.size(), ComponentLocation.class.getSimpleName())));
                    }
                });
            }
        }.walk(model);
    }
}

