/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.function.BiConsumer;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.privileged.util.AttributeEvaluator;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionBasedValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class ExpressionValueResolver<T>
implements ExpressionBasedValueResolver<T>,
Initialisable {
    @Inject
    private ExtendedExpressionManager extendedExpressionManager;
    final AttributeEvaluator evaluator;
    private boolean evaluatorInitialized = false;
    private final String expression;
    private BiConsumer<AttributeEvaluator, ExtendedExpressionManager> evaluatorInitialiser = (evaluator, extendedExpressionManager) -> {
        ExtendedExpressionManager extendedExpressionManager2 = extendedExpressionManager;
        synchronized (extendedExpressionManager2) {
            if (!this.evaluatorInitialized) {
                evaluator.initialize((ExtendedExpressionManager)extendedExpressionManager);
                this.evaluatorInitialiser = (e, c) -> {};
                this.evaluatorInitialized = true;
            }
        }
    };

    ExpressionValueResolver(String expression, DataType expectedDataType) {
        Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)expression), "Expression cannot be blank or null");
        this.expression = expression;
        this.evaluator = new AttributeEvaluator(expression, expectedDataType);
    }

    public ExpressionValueResolver(String expression) {
        Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)expression), "Expression cannot be blank or null");
        this.expression = expression;
        this.evaluator = new AttributeEvaluator(expression);
    }

    void setExtendedExpressionManager(ExtendedExpressionManager extendedExpressionManager) {
        this.extendedExpressionManager = extendedExpressionManager;
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.extendedExpressionManager);
        this.initEvaluator();
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        TypedValue typedValue = this.evaluator.resolveTypedValue(context.getEvent());
        Object value = typedValue.getValue();
        if (ClassUtils.isInstance(ValueResolver.class, value)) {
            value = ((ValueResolver)value).resolve(context);
        }
        return value;
    }

    void initEvaluator() {
        this.evaluatorInitialiser.accept(this.evaluator, this.extendedExpressionManager);
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }
}

