/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.aop.aspectj;

import org.springframework.AAA.aop.aspectj.AspectInstanceFactory;
import org.springframework.AAA.core.Ordered;
import org.springframework.AAA.util.Assert;

public class SingletonAspectInstanceFactory
implements AspectInstanceFactory {
    private final Object aspectInstance;

    public SingletonAspectInstanceFactory(Object aspectInstance) {
        Assert.notNull(aspectInstance, "Aspect instance must not be null");
        this.aspectInstance = aspectInstance;
    }

    @Override
    public final Object getAspectInstance() {
        return this.aspectInstance;
    }

    @Override
    public ClassLoader getAspectClassLoader() {
        return this.aspectInstance.getClass().getClassLoader();
    }

    @Override
    public int getOrder() {
        if (this.aspectInstance instanceof Ordered) {
            return ((Ordered)this.aspectInstance).getOrder();
        }
        return this.getOrderForAspectClass(this.aspectInstance.getClass());
    }

    protected int getOrderForAspectClass(Class<?> aspectClass) {
        return Integer.MAX_VALUE;
    }
}

