/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.aop.framework;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.AAA.aop.Advisor;
import org.springframework.AAA.aop.framework.Advised;
import org.springframework.AAA.aop.framework.AopInfrastructureBean;
import org.springframework.AAA.aop.framework.ProxyFactory;
import org.springframework.AAA.aop.framework.ProxyProcessorSupport;
import org.springframework.AAA.aop.support.AopUtils;
import org.springframework.AAA.beans.factory.config.BeanPostProcessor;

public abstract class AbstractAdvisingBeanPostProcessor
extends ProxyProcessorSupport
implements BeanPostProcessor {
    protected Advisor advisor;
    protected boolean beforeExistingAdvisors = false;
    private final Map<Class<?>, Boolean> eligibleBeans = new ConcurrentHashMap(64);

    public void setBeforeExistingAdvisors(boolean beforeExistingAdvisors) {
        this.beforeExistingAdvisors = beforeExistingAdvisors;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) {
        Advised advised;
        if (bean instanceof AopInfrastructureBean) {
            return bean;
        }
        if (bean instanceof Advised && !(advised = (Advised)bean).isFrozen() && this.isEligible(AopUtils.getTargetClass(bean))) {
            if (this.beforeExistingAdvisors) {
                advised.addAdvisor(0, this.advisor);
            } else {
                advised.addAdvisor(this.advisor);
            }
            return bean;
        }
        if (this.isEligible(bean, beanName)) {
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.copyFrom(this);
            proxyFactory.setTarget(bean);
            if (!proxyFactory.isProxyTargetClass()) {
                this.evaluateProxyInterfaces(bean.getClass(), proxyFactory);
            }
            proxyFactory.addAdvisor(this.advisor);
            return proxyFactory.getProxy(this.getProxyClassLoader());
        }
        return bean;
    }

    protected boolean isEligible(Object bean, String beanName) {
        return this.isEligible(bean.getClass());
    }

    protected boolean isEligible(Class<?> targetClass) {
        Boolean eligible = this.eligibleBeans.get(targetClass);
        if (eligible != null) {
            return eligible;
        }
        eligible = AopUtils.canApply(this.advisor, targetClass);
        this.eligibleBeans.put(targetClass, eligible);
        return eligible;
    }
}

