/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.aop.target;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import org.springframework.AAA.aop.target.AbstractBeanFactoryBasedTargetSource;
import org.springframework.AAA.aop.target.SingletonTargetSource;
import org.springframework.AAA.beans.BeansException;
import org.springframework.AAA.beans.factory.BeanDefinitionStoreException;
import org.springframework.AAA.beans.factory.BeanFactory;
import org.springframework.AAA.beans.factory.DisposableBean;
import org.springframework.AAA.beans.factory.config.ConfigurableBeanFactory;

public abstract class AbstractPrototypeBasedTargetSource
extends AbstractBeanFactoryBasedTargetSource {
    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setBeanFactory(beanFactory);
        if (!beanFactory.isPrototype(this.getTargetBeanName())) {
            throw new BeanDefinitionStoreException("Cannot use prototype-based TargetSource against non-prototype bean with name '" + this.getTargetBeanName() + "': instances would not be independent");
        }
    }

    protected Object newPrototypeInstance() throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Creating new instance of bean '" + this.getTargetBeanName() + "'");
        }
        return this.getBeanFactory().getBean(this.getTargetBeanName());
    }

    protected void destroyPrototypeInstance(Object target) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Destroying instance of bean '" + this.getTargetBeanName() + "'");
        }
        if (this.getBeanFactory() instanceof ConfigurableBeanFactory) {
            ((ConfigurableBeanFactory)this.getBeanFactory()).destroyBean(this.getTargetBeanName(), target);
        } else if (target instanceof DisposableBean) {
            try {
                ((DisposableBean)target).destroy();
            }
            catch (Throwable ex) {
                this.logger.error("Couldn't invoke destroy method of bean with name '" + this.getTargetBeanName() + "'", ex);
            }
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        throw new NotSerializableException("A prototype-based TargetSource itself is not deserializable - just a disconnected SingletonTargetSource is");
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Disconnecting TargetSource [" + this + "]");
        }
        try {
            return new SingletonTargetSource(this.getTarget());
        }
        catch (Exception ex) {
            this.logger.error("Cannot get target for disconnecting TargetSource [" + this + "]", ex);
            throw new NotSerializableException("Cannot get target for disconnecting TargetSource [" + this + "]: " + ex);
        }
    }
}

