/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.context.config;

import org.springframework.AAA.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.AAA.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.AAA.context.config.AbstractPropertyLoadingBeanDefinitionParser;
import org.springframework.AAA.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.AAA.util.StringUtils;
import org.w3c.dom.Element;

class PropertyPlaceholderBeanDefinitionParser
extends AbstractPropertyLoadingBeanDefinitionParser {
    private static final String SYSTEM_PROPERTIES_MODE_ATTRIB = "system-properties-mode";
    private static final String SYSTEM_PROPERTIES_MODE_DEFAULT = "ENVIRONMENT";

    PropertyPlaceholderBeanDefinitionParser() {
    }

    @Override
    protected Class<?> getBeanClass(Element element) {
        if (element.getAttribute(SYSTEM_PROPERTIES_MODE_ATTRIB).equals(SYSTEM_PROPERTIES_MODE_DEFAULT)) {
            return PropertySourcesPlaceholderConfigurer.class;
        }
        return PropertyPlaceholderConfigurer.class;
    }

    @Override
    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        super.doParse(element, builder);
        builder.addPropertyValue("ignoreUnresolvablePlaceholders", Boolean.valueOf(element.getAttribute("ignore-unresolvable")));
        String systemPropertiesModeName = element.getAttribute(SYSTEM_PROPERTIES_MODE_ATTRIB);
        if (StringUtils.hasLength(systemPropertiesModeName) && !systemPropertiesModeName.equals(SYSTEM_PROPERTIES_MODE_DEFAULT)) {
            builder.addPropertyValue("systemPropertiesModeName", "SYSTEM_PROPERTIES_MODE_" + systemPropertiesModeName);
        }
    }
}

