/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.context.expression;

import org.springframework.AAA.beans.BeansException;
import org.springframework.AAA.beans.factory.BeanFactory;
import org.springframework.AAA.expression.AccessException;
import org.springframework.AAA.expression.BeanResolver;
import org.springframework.AAA.expression.EvaluationContext;
import org.springframework.AAA.util.Assert;

public class BeanFactoryResolver
implements BeanResolver {
    private final BeanFactory beanFactory;

    public BeanFactoryResolver(BeanFactory beanFactory) {
        Assert.notNull(beanFactory, "BeanFactory must not be null");
        this.beanFactory = beanFactory;
    }

    @Override
    public Object resolve(EvaluationContext context, String beanName) throws AccessException {
        try {
            return this.beanFactory.getBean(beanName);
        }
        catch (BeansException ex) {
            throw new AccessException("Could not resolve bean reference against BeanFactory", ex);
        }
    }
}

