/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.core.convert.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.springframework.AAA.core.convert.ConversionService;
import org.springframework.AAA.core.convert.TypeDescriptor;
import org.springframework.AAA.core.convert.converter.ConditionalGenericConverter;
import org.springframework.AAA.core.convert.converter.GenericConverter;
import org.springframework.AAA.core.convert.support.CollectionToStringConverter;
import org.springframework.AAA.util.ObjectUtils;

final class ArrayToStringConverter
implements ConditionalGenericConverter {
    private final CollectionToStringConverter helperConverter;

    public ArrayToStringConverter(ConversionService conversionService) {
        this.helperConverter = new CollectionToStringConverter(conversionService);
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object[].class, String.class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.helperConverter.matches(sourceType, targetType);
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.helperConverter.convert(Arrays.asList(ObjectUtils.toObjectArray(source)), sourceType, targetType);
    }
}

