/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.core.style;

import org.springframework.AAA.core.style.DefaultToStringStyler;
import org.springframework.AAA.core.style.StylerUtils;
import org.springframework.AAA.core.style.ToStringStyler;
import org.springframework.AAA.core.style.ValueStyler;
import org.springframework.AAA.util.Assert;

public class ToStringCreator {
    private static final ToStringStyler DEFAULT_TO_STRING_STYLER = new DefaultToStringStyler(StylerUtils.DEFAULT_VALUE_STYLER);
    private final StringBuilder buffer = new StringBuilder(256);
    private final ToStringStyler styler;
    private final Object object;
    private boolean styledFirstField;

    public ToStringCreator(Object obj) {
        this(obj, (ToStringStyler)null);
    }

    public ToStringCreator(Object obj, ValueStyler styler) {
        this(obj, new DefaultToStringStyler(styler != null ? styler : StylerUtils.DEFAULT_VALUE_STYLER));
    }

    public ToStringCreator(Object obj, ToStringStyler styler) {
        Assert.notNull(obj, "The object to be styled must not be null");
        this.object = obj;
        this.styler = styler != null ? styler : DEFAULT_TO_STRING_STYLER;
        this.styler.styleStart(this.buffer, this.object);
    }

    public ToStringCreator append(String fieldName, byte value) {
        return this.append(fieldName, new Byte(value));
    }

    public ToStringCreator append(String fieldName, short value) {
        return this.append(fieldName, new Short(value));
    }

    public ToStringCreator append(String fieldName, int value) {
        return this.append(fieldName, new Integer(value));
    }

    public ToStringCreator append(String fieldName, long value) {
        return this.append(fieldName, new Long(value));
    }

    public ToStringCreator append(String fieldName, float value) {
        return this.append(fieldName, new Float(value));
    }

    public ToStringCreator append(String fieldName, double value) {
        return this.append(fieldName, new Double(value));
    }

    public ToStringCreator append(String fieldName, boolean value) {
        return this.append(fieldName, (Object)value);
    }

    public ToStringCreator append(String fieldName, Object value) {
        this.printFieldSeparatorIfNecessary();
        this.styler.styleField(this.buffer, fieldName, value);
        return this;
    }

    private void printFieldSeparatorIfNecessary() {
        if (this.styledFirstField) {
            this.styler.styleFieldSeparator(this.buffer);
        } else {
            this.styledFirstField = true;
        }
    }

    public ToStringCreator append(Object value) {
        this.styler.styleValue(this.buffer, value);
        return this;
    }

    public String toString() {
        this.styler.styleEnd(this.buffer, this.object);
        return this.buffer.toString();
    }
}

