/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.core.task.support;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import org.springframework.AAA.core.task.AsyncListenableTaskExecutor;
import org.springframework.AAA.core.task.TaskRejectedException;
import org.springframework.AAA.util.Assert;
import org.springframework.AAA.util.concurrent.ListenableFuture;
import org.springframework.AAA.util.concurrent.ListenableFutureTask;

public class TaskExecutorAdapter
implements AsyncListenableTaskExecutor {
    private final Executor concurrentExecutor;

    public TaskExecutorAdapter(Executor concurrentExecutor) {
        Assert.notNull(concurrentExecutor, "Executor must not be null");
        this.concurrentExecutor = concurrentExecutor;
    }

    @Override
    public void execute(Runnable task) {
        try {
            this.concurrentExecutor.execute(task);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + this.concurrentExecutor + "] did not accept task: " + task, ex);
        }
    }

    @Override
    public void execute(Runnable task, long startTimeout) {
        this.execute(task);
    }

    @Override
    public Future<?> submit(Runnable task) {
        try {
            if (this.concurrentExecutor instanceof ExecutorService) {
                return ((ExecutorService)this.concurrentExecutor).submit(task);
            }
            FutureTask<Object> future = new FutureTask<Object>(task, null);
            this.concurrentExecutor.execute(future);
            return future;
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + this.concurrentExecutor + "] did not accept task: " + task, ex);
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        try {
            if (this.concurrentExecutor instanceof ExecutorService) {
                return ((ExecutorService)this.concurrentExecutor).submit(task);
            }
            FutureTask<T> future = new FutureTask<T>(task);
            this.concurrentExecutor.execute(future);
            return future;
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + this.concurrentExecutor + "] did not accept task: " + task, ex);
        }
    }

    @Override
    public ListenableFuture<?> submitListenable(Runnable task) {
        try {
            ListenableFutureTask<Object> future = new ListenableFutureTask<Object>(task, null);
            this.concurrentExecutor.execute(future);
            return future;
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + this.concurrentExecutor + "] did not accept task: " + task, ex);
        }
    }

    @Override
    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        try {
            ListenableFutureTask<T> future = new ListenableFutureTask<T>(task);
            this.concurrentExecutor.execute(future);
            return future;
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + this.concurrentExecutor + "] did not accept task: " + task, ex);
        }
    }
}

