/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.expression.spel.ast;

import org.springframework.AAA.expression.AccessException;
import org.springframework.AAA.expression.BeanResolver;
import org.springframework.AAA.expression.EvaluationException;
import org.springframework.AAA.expression.TypedValue;
import org.springframework.AAA.expression.spel.ExpressionState;
import org.springframework.AAA.expression.spel.SpelEvaluationException;
import org.springframework.AAA.expression.spel.SpelMessage;
import org.springframework.AAA.expression.spel.ast.SpelNodeImpl;

public class BeanReference
extends SpelNodeImpl {
    private final String beanName;

    public BeanReference(int pos, String beanName) {
        super(pos, new SpelNodeImpl[0]);
        this.beanName = beanName;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        BeanResolver beanResolver = state.getEvaluationContext().getBeanResolver();
        if (beanResolver == null) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.NO_BEAN_RESOLVER_REGISTERED, this.beanName);
        }
        try {
            return new TypedValue(beanResolver.resolve(state.getEvaluationContext(), this.beanName));
        }
        catch (AccessException ex) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.EXCEPTION_DURING_BEAN_RESOLUTION, this.beanName, ex.getMessage());
        }
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder("@");
        if (!this.beanName.contains(".")) {
            sb.append(this.beanName);
        } else {
            sb.append("'").append(this.beanName).append("'");
        }
        return sb.toString();
    }
}

