/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.format.datetime.joda;

import java.util.Locale;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.AAA.core.NamedThreadLocal;
import org.springframework.AAA.format.datetime.joda.JodaTimeContext;

public final class JodaTimeContextHolder {
    private static final ThreadLocal<JodaTimeContext> jodaTimeContextHolder = new NamedThreadLocal<JodaTimeContext>("JodaTime Context");

    public static void resetJodaTimeContext() {
        jodaTimeContextHolder.remove();
    }

    public static void setJodaTimeContext(JodaTimeContext jodaTimeContext) {
        if (jodaTimeContext == null) {
            JodaTimeContextHolder.resetJodaTimeContext();
        } else {
            jodaTimeContextHolder.set(jodaTimeContext);
        }
    }

    public static JodaTimeContext getJodaTimeContext() {
        return jodaTimeContextHolder.get();
    }

    public static DateTimeFormatter getFormatter(DateTimeFormatter formatter, Locale locale) {
        DateTimeFormatter formatterToUse = locale != null ? formatter.withLocale(locale) : formatter;
        JodaTimeContext context = JodaTimeContextHolder.getJodaTimeContext();
        return context != null ? context.getFormatter(formatterToUse) : formatterToUse;
    }
}

