/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.format.number;

import java.util.Set;
import org.springframework.AAA.context.support.EmbeddedValueResolutionSupport;
import org.springframework.AAA.format.AnnotationFormatterFactory;
import org.springframework.AAA.format.Formatter;
import org.springframework.AAA.format.Parser;
import org.springframework.AAA.format.Printer;
import org.springframework.AAA.format.annotation.NumberFormat;
import org.springframework.AAA.format.number.CurrencyFormatter;
import org.springframework.AAA.format.number.NumberFormatter;
import org.springframework.AAA.format.number.PercentFormatter;
import org.springframework.AAA.util.NumberUtils;
import org.springframework.AAA.util.StringUtils;

public class NumberFormatAnnotationFormatterFactory
extends EmbeddedValueResolutionSupport
implements AnnotationFormatterFactory<NumberFormat> {
    @Override
    public Set<Class<?>> getFieldTypes() {
        return NumberUtils.STANDARD_NUMBER_TYPES;
    }

    @Override
    public Printer<Number> getPrinter(NumberFormat annotation, Class<?> fieldType) {
        return this.configureFormatterFrom(annotation);
    }

    @Override
    public Parser<Number> getParser(NumberFormat annotation, Class<?> fieldType) {
        return this.configureFormatterFrom(annotation);
    }

    private Formatter<Number> configureFormatterFrom(NumberFormat annotation) {
        if (StringUtils.hasLength(annotation.pattern())) {
            return new NumberFormatter(this.resolveEmbeddedValue(annotation.pattern()));
        }
        NumberFormat.Style style = annotation.style();
        if (style == NumberFormat.Style.PERCENT) {
            return new PercentFormatter();
        }
        if (style == NumberFormat.Style.CURRENCY) {
            return new CurrencyFormatter();
        }
        return new NumberFormatter();
    }
}

