/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.jmx.support;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import org.springframework.AAA.beans.factory.DisposableBean;
import org.springframework.AAA.beans.factory.FactoryBean;
import org.springframework.AAA.beans.factory.InitializingBean;
import org.springframework.AAA.jmx.JmxException;
import org.springframework.AAA.jmx.support.JmxUtils;
import org.springframework.AAA.jmx.support.MBeanRegistrationSupport;
import org.springframework.AAA.jmx.support.ObjectNameManager;
import org.springframework.AAA.util.CollectionUtils;

public class ConnectorServerFactoryBean
extends MBeanRegistrationSupport
implements FactoryBean<JMXConnectorServer>,
InitializingBean,
DisposableBean {
    public static final String DEFAULT_SERVICE_URL = "service:jmx:jmxmp://localhost:9875";
    private String serviceUrl = "service:jmx:jmxmp://localhost:9875";
    private Map<String, Object> environment = new HashMap<String, Object>();
    private MBeanServerForwarder forwarder;
    private ObjectName objectName;
    private boolean threaded = false;
    private boolean daemon = false;
    private JMXConnectorServer connectorServer;

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setEnvironment(Properties environment) {
        CollectionUtils.mergePropertiesIntoMap(environment, this.environment);
    }

    public void setEnvironmentMap(Map<String, ?> environment) {
        if (environment != null) {
            this.environment.putAll(environment);
        }
    }

    public void setForwarder(MBeanServerForwarder forwarder) {
        this.forwarder = forwarder;
    }

    public void setObjectName(Object objectName) throws MalformedObjectNameException {
        this.objectName = ObjectNameManager.getInstance(objectName);
    }

    public void setThreaded(boolean threaded) {
        this.threaded = threaded;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    @Override
    public void afterPropertiesSet() throws JMException, IOException {
        if (this.server == null) {
            this.server = JmxUtils.locateMBeanServer();
        }
        JMXServiceURL url = new JMXServiceURL(this.serviceUrl);
        this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, this.environment, this.server);
        if (this.forwarder != null) {
            this.connectorServer.setMBeanServerForwarder(this.forwarder);
        }
        if (this.objectName != null) {
            this.doRegister(this.connectorServer, this.objectName);
        }
        try {
            if (this.threaded) {
                Thread connectorThread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            ConnectorServerFactoryBean.this.connectorServer.start();
                        }
                        catch (IOException ex) {
                            throw new JmxException("Could not start JMX connector server after delay", ex);
                        }
                    }
                };
                connectorThread.setName("JMX Connector Thread [" + this.serviceUrl + "]");
                connectorThread.setDaemon(this.daemon);
                connectorThread.start();
            } else {
                this.connectorServer.start();
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("JMX connector server started: " + this.connectorServer);
            }
        }
        catch (IOException ex) {
            this.unregisterBeans();
            throw ex;
        }
    }

    @Override
    public JMXConnectorServer getObject() {
        return this.connectorServer;
    }

    @Override
    public Class<? extends JMXConnectorServer> getObjectType() {
        return this.connectorServer != null ? this.connectorServer.getClass() : JMXConnectorServer.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public void destroy() throws IOException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Stopping JMX connector server: " + this.connectorServer);
        }
        try {
            this.connectorServer.stop();
        }
        finally {
            this.unregisterBeans();
        }
    }
}

