/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.mojo;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.connectivity.model.api.RestConnectAPIModel;
import org.mule.connectivity.model.api.RestConnectModelBuilder;
import org.mule.connectivity.mojo.Raml2ConnectorMojo;
import org.mule.connectivity.templateEngine.builder.SmartConnectorTemplateEngineBuilder;
import org.mule.connectivity.util.MojoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="raml2smartconnector", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresProject=false)
public class Raml2SmartConnectorMojo
extends AbstractMojo {
    private Logger logger = LoggerFactory.getLogger(Raml2ConnectorMojo.class);
    @Parameter(property="raml", required=true)
    private String raml;
    @Parameter(property="name")
    private String name;
    @Parameter(property="outputDir", defaultValue="target")
    private File outputDir;

    public void execute() throws MojoExecutionException {
        try {
            RestConnectAPIModel model = RestConnectModelBuilder.createModel().fromRaml(MojoUtils.getMainRamlFile(this.raml)).withName(this.name).build();
            ((SmartConnectorTemplateEngineBuilder)((SmartConnectorTemplateEngineBuilder)SmartConnectorTemplateEngineBuilder.createSmartConnector().fromModel(model)).inOutputDir(this.outputDir.toPath())).execute();
        }
        catch (Exception e) {
            this.logger.error("Failed to build connector.", (Throwable)e);
            throw new MojoExecutionException("Failed to build connector", e);
        }
    }
}

