/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.processor;

import java.beans.PropertyDescriptor;
import org.mule.runtime.config.internal.OptionalObjectsController;
import org.springframework.AAA.beans.BeansException;
import org.springframework.AAA.beans.PropertyValues;
import org.springframework.AAA.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.AAA.beans.factory.support.DefaultListableBeanFactory;

public class DiscardedOptionalBeanPostProcessor
implements InstantiationAwareBeanPostProcessor {
    private final OptionalObjectsController optionalObjectsController;
    private final DefaultListableBeanFactory beanFactory;

    public DiscardedOptionalBeanPostProcessor(OptionalObjectsController optionalObjectsController, DefaultListableBeanFactory beanFactory) {
        this.optionalObjectsController = optionalObjectsController;
        this.beanFactory = beanFactory;
    }

    @Override
    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) throws BeansException {
        return null;
    }

    @Override
    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        return !this.optionalObjectsController.isDiscarded(beanName);
    }

    @Override
    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        return this.optionalObjectsController.isDiscarded(beanName) ? null : pvs;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.optionalObjectsController.isDiscarded(beanName)) {
            if (this.beanFactory.containsBeanDefinition(beanName)) {
                this.beanFactory.removeBeanDefinition(beanName);
            }
            this.beanFactory.destroySingleton(beanName);
            return null;
        }
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

