/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.construct;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.AsyncProcessingStrategyFactory;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.construct.AbstractFlowConstruct;
import org.mule.runtime.core.internal.construct.AbstractPipeline;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.processor.strategy.DirectProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.TransactionAwareWorkQueueProcessingStrategyFactory;
import org.mule.runtime.core.internal.routing.requestreply.SimpleAsyncRequestReplyRequester;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.core.privileged.endpoint.LegacyImmutableEndpoint;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.exception.AbstractExceptionListener;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChainBuilder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultFlowBuilder
implements Flow.Builder {
    private final String name;
    private final MuleContext muleContext;
    private MessageSource source;
    private List<Processor> processors = Collections.emptyList();
    private FlowExceptionHandler exceptionListener;
    private ProcessingStrategyFactory processingStrategyFactory;
    private String initialState = "started";
    private int maxConcurrency = AsyncProcessingStrategyFactory.DEFAULT_MAX_CONCURRENCY;
    private DefaultFlow flow;

    public DefaultFlowBuilder(String name, MuleContext muleContext) {
        Preconditions.checkArgument(StringUtils.isNotEmpty((CharSequence)name), "name cannot be empty");
        Preconditions.checkArgument(muleContext != null, "muleContext cannot be null");
        this.name = name;
        this.muleContext = muleContext;
    }

    @Override
    public Flow.Builder source(MessageSource source) {
        this.checkImmutable();
        Preconditions.checkArgument(source != null, "source cannot be null");
        this.source = source;
        return this;
    }

    @Override
    public Flow.Builder processors(List<Processor> processors) {
        this.checkImmutable();
        Preconditions.checkArgument(processors != null, "processors cannot be null");
        this.processors = processors;
        return this;
    }

    @Override
    public Flow.Builder processors(Processor ... processors) {
        this.checkImmutable();
        this.processors = Arrays.asList(processors);
        return this;
    }

    @Override
    public Flow.Builder messagingExceptionHandler(FlowExceptionHandler exceptionListener) {
        this.checkImmutable();
        this.exceptionListener = exceptionListener;
        return this;
    }

    @Override
    public Flow.Builder processingStrategyFactory(ProcessingStrategyFactory processingStrategyFactory) {
        this.checkImmutable();
        Preconditions.checkArgument(processingStrategyFactory != null, "processingStrategyFactory cannot be null");
        this.processingStrategyFactory = processingStrategyFactory;
        return this;
    }

    @Override
    public Flow.Builder withDirectProcessingStrategyFactory() {
        return this.processingStrategyFactory(new DirectProcessingStrategyFactory());
    }

    @Override
    public Flow.Builder initialState(String initialState) {
        this.checkImmutable();
        Preconditions.checkArgument(initialState != null, "initialState cannot be null");
        this.initialState = initialState;
        return this;
    }

    @Override
    public Flow.Builder maxConcurrency(int maxConcurrency) {
        this.checkImmutable();
        Preconditions.checkArgument(maxConcurrency > 0, "maxConcurrency cannot be less than 1");
        this.maxConcurrency = maxConcurrency;
        return this;
    }

    @Override
    public Flow build() {
        this.checkImmutable();
        FlowConstructStatistics flowStatistics = AbstractFlowConstruct.createFlowStatistics(this.name, this.muleContext);
        if (this.exceptionListener instanceof AbstractExceptionListener) {
            ((AbstractExceptionListener)((Object)this.exceptionListener)).setStatistics(flowStatistics);
        }
        this.flow = new DefaultFlow(this.name, this.muleContext, this.source, this.processors, Optional.ofNullable(this.exceptionListener), Optional.ofNullable(this.processingStrategyFactory), this.initialState, this.maxConcurrency, flowStatistics);
        return this.flow;
    }

    protected final void checkImmutable() {
        if (this.flow != null) {
            throw new IllegalStateException("Cannot change attributes once the flow was built");
        }
    }

    public static class DefaultFlow
    extends AbstractPipeline
    implements Flow {
        private final MessagingExceptionResolver exceptionResolver = new MessagingExceptionResolver(this);
        private boolean handleReplyTo = false;

        protected DefaultFlow(String name, MuleContext muleContext, MessageSource source, List<Processor> processors, Optional<FlowExceptionHandler> exceptionListener, Optional<ProcessingStrategyFactory> processingStrategyFactory, String initialState, int maxConcurrency, FlowConstructStatistics flowConstructStatistics) {
            super(name, muleContext, source, processors, exceptionListener, processingStrategyFactory, initialState, maxConcurrency, flowConstructStatistics);
        }

        @Override
        protected void doInitialise() throws MuleException {
            super.doInitialise();
            if (((MuleContextWithRegistries)this.muleContext).getRegistry().lookupObject("_compatibilityPluginInstalled") != null) {
                this.handleReplyTo = true;
            }
        }

        @Override
        public CoreEvent process(CoreEvent event) throws MuleException {
            return MessageProcessors.processToApply(event, this);
        }

        @Override
        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            return Flux.from(publisher).doOnNext(this.assertStarted()).flatMap(event -> {
                PrivilegedEvent request = this.createMuleEventForCurrentFlow((PrivilegedEvent)event);
                try {
                    this.getSink().accept(request);
                }
                catch (RejectedExecutionException ree) {
                    MessagingException me2 = new MessagingException((CoreEvent)event, ree, (Component)this);
                    ((BaseEventContext)request.getContext()).error(this.exceptionResolver.resolve(me2, this.getMuleContext()));
                }
                return Mono.from(((BaseEventContext)request.getContext()).getResponsePublisher()).cast(PrivilegedEvent.class).map(r -> {
                    PrivilegedEvent result = this.createReturnEventForParentFlowConstruct((PrivilegedEvent)r, (InternalEvent)event);
                    return result;
                }).onErrorMap(MessagingException.class, me -> {
                    me.setProcessedEvent(this.createReturnEventForParentFlowConstruct((PrivilegedEvent)me.getEvent(), (InternalEvent)event));
                    return me;
                });
            });
        }

        private PrivilegedEvent createMuleEventForCurrentFlow(PrivilegedEvent event) {
            if (this.handleReplyTo) {
                event = InternalEvent.builder(event).replyToHandler(null).replyToDestination(event.getReplyToDestination()).build();
                PrivilegedEvent.setCurrentEvent(event);
            }
            return event;
        }

        private PrivilegedEvent createReturnEventForParentFlowConstruct(PrivilegedEvent result, InternalEvent original) {
            if (this.handleReplyTo) {
                if (result != null) {
                    result = InternalEvent.builder(result).replyToHandler(original.getReplyToHandler()).replyToDestination(original.getReplyToDestination()).build();
                }
                PrivilegedEvent.setCurrentEvent(result);
            }
            return result;
        }

        @Override
        protected void configureMessageProcessors(MessageProcessorChainBuilder builder) throws MuleException {
            super.configureMessageProcessors(builder);
            if (this.getSource() instanceof LegacyImmutableEndpoint && !((LegacyImmutableEndpoint)((Object)this.getSource())).getExchangePattern().hasResponse()) {
                builder.chain(new SimpleAsyncRequestReplyRequester.AsyncReplyToPropertyRequestReplyReplier(this.getSource()));
            }
        }

        @Override
        protected ProcessingStrategyFactory createDefaultProcessingStrategyFactory() {
            return new TransactionAwareWorkQueueProcessingStrategyFactory();
        }

        @Override
        public String getConstructType() {
            return "Flow";
        }

        @Override
        public boolean isSynchronous() {
            return this.getProcessingStrategy() != null ? this.getProcessingStrategy().isSynchronous() : true;
        }

        @Override
        protected EventContext createEventContext(Optional<CompletableFuture<Void>> externalCompletion) {
            return EventContextFactory.create(this, this.getLocation(), null, externalCompletion);
        }

        @Override
        protected BaseEventContext createChildEventContext(EventContext parent) {
            return DefaultEventContext.child((BaseEventContext)parent, Optional.ofNullable(this.getLocation()), this.getExceptionListener());
        }
    }
}

