/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.event;

import java.io.Serializable;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.ProcessorsTrace;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.exception.NullExceptionHandler;
import org.mule.runtime.core.api.management.stats.ProcessingTime;
import org.mule.runtime.core.internal.context.notification.DefaultProcessorsTrace;
import org.mule.runtime.core.internal.event.AbstractEventContext;
import org.mule.runtime.core.privileged.event.BaseEventContext;

public final class DefaultEventContext
extends AbstractEventContext
implements Serializable {
    private static final long serialVersionUID = -3664490832964509653L;
    private final String id;
    private final String correlationId;
    private final Instant receivedDate = Instant.now();
    private final String serverId;
    private final ComponentLocation location;
    private final ProcessingTime processingTime;
    private final ProcessorsTrace processorsTrace = new DefaultProcessorsTrace();

    public static BaseEventContext child(BaseEventContext parent, Optional<ComponentLocation> componentLocation) {
        return DefaultEventContext.child(parent, componentLocation, NullExceptionHandler.getInstance());
    }

    public static BaseEventContext child(BaseEventContext parent, Optional<ComponentLocation> componentLocation, FlowExceptionHandler exceptionHandler) {
        ChildEventContext child = new ChildEventContext(parent, componentLocation.orElse(null), exceptionHandler);
        if (parent instanceof AbstractEventContext) {
            ((AbstractEventContext)parent).addChildContext(child);
        }
        return child;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getCorrelationId() {
        return this.correlationId != null ? this.correlationId : this.id;
    }

    @Override
    public Instant getReceivedTime() {
        return this.receivedDate;
    }

    @Override
    public ComponentLocation getOriginatingLocation() {
        return this.location;
    }

    @Override
    public Optional<ProcessingTime> getProcessingTime() {
        return Optional.ofNullable(this.processingTime);
    }

    @Override
    public boolean isCorrelationIdFromSource() {
        return this.correlationId != null;
    }

    @Override
    public ProcessorsTrace getProcessorsTrace() {
        return this.processorsTrace;
    }

    @Override
    public Optional<BaseEventContext> getParentContext() {
        return Optional.empty();
    }

    public DefaultEventContext(FlowConstruct flow, ComponentLocation location, String correlationId, Optional<CompletableFuture<Void>> externalCompletion) {
        super(flow.getExceptionListener(), externalCompletion);
        this.id = flow.getUniqueIdString();
        this.serverId = flow.getServerId();
        this.location = location;
        this.processingTime = ProcessingTime.newInstance(flow);
        this.correlationId = correlationId;
    }

    public DefaultEventContext(String id, String serverId, ComponentLocation location, String correlationId, Optional<CompletableFuture<Void>> externalCompletion, FlowExceptionHandler exceptionHandler) {
        super(exceptionHandler, externalCompletion);
        this.id = id;
        this.serverId = serverId;
        this.location = location;
        this.processingTime = null;
        this.correlationId = correlationId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " { id: " + this.id + "; correlationId: " + this.correlationId + "; flowName: " + this.getOriginatingLocation().getRootContainerName() + "; serverId: " + this.serverId + " }";
    }

    private static class ChildEventContext
    extends AbstractEventContext
    implements Serializable {
        private static final long serialVersionUID = 1054412872901205234L;
        private final BaseEventContext parent;
        private final ComponentLocation componentLocation;
        private final String id;

        private ChildEventContext(BaseEventContext parent, ComponentLocation componentLocation, FlowExceptionHandler messagingExceptionHandler) {
            super(messagingExceptionHandler, Optional.empty());
            this.parent = parent;
            this.componentLocation = componentLocation;
            this.id = parent.getId() + System.identityHashCode(this);
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getCorrelationId() {
            return this.parent.getCorrelationId();
        }

        @Override
        public Instant getReceivedTime() {
            return this.parent.getReceivedTime();
        }

        @Override
        public ComponentLocation getOriginatingLocation() {
            return this.parent.getOriginatingLocation();
        }

        @Override
        public Optional<ProcessingTime> getProcessingTime() {
            return this.parent.getProcessingTime();
        }

        @Override
        public ProcessorsTrace getProcessorsTrace() {
            return this.parent.getProcessorsTrace();
        }

        @Override
        public boolean isCorrelationIdFromSource() {
            return this.parent.isCorrelationIdFromSource();
        }

        public String toString() {
            return this.getClass().getSimpleName() + " { id: " + this.getId() + "; correlationId: " + this.parent.getCorrelationId() + "; flowName: " + this.parent.getOriginatingLocation().getRootContainerName() + "; commponentLocation: " + (this.componentLocation != null ? this.componentLocation.getLocation() : "") + ";";
        }

        @Override
        public Optional<BaseEventContext> getParentContext() {
            return Optional.of(this.parent);
        }
    }
}

