/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public class StringByteSizeCalculator {
    private static final int WRITE_CHUNK = 8192;

    public long count(String payload, Charset charset) {
        CountingOutputStream countingStream = new CountingOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)countingStream, charset);
        try {
            for (int i = 0; i < payload.length(); i += 8192) {
                int end = Math.min(payload.length(), i + 8192);
                ((Writer)writer).write(payload, i, end - i);
            }
            ((Writer)writer).flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return countingStream.getSize();
    }

    private class CountingOutputStream
    extends OutputStream {
        private long size = 0L;

        private CountingOutputStream() {
        }

        @Override
        public void write(int b) {
            ++this.size;
        }

        @Override
        public void write(byte[] b) {
            this.size += (long)b.length;
        }

        @Override
        public void write(byte[] b, int offset, int len) {
            this.size += (long)len;
        }

        public long getSize() {
            return this.size;
        }
    }
}

