/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.serializer;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.serialization.SerializationProtocol;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.internal.serialization.JavaExternalSerializerProtocol;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.api.serializer.protocol.CustomJavaSerializationProtocol;

public class ArtifactObjectSerializer
implements ObjectSerializer,
Initialisable,
MuleContextAware {
    private volatile JavaExternalSerializerProtocol javaExternalSerializerProtocol;
    private volatile CustomJavaSerializationProtocol javaInternalSerializerProtocol;
    private MuleContext muleContext;

    public ArtifactObjectSerializer(ClassLoaderRepository classLoaderRepository) {
        Preconditions.checkArgument(classLoaderRepository != null, "ClassLoaderRepository cannot be null");
        this.javaExternalSerializerProtocol = new JavaExternalSerializerProtocol();
        this.javaInternalSerializerProtocol = new CustomJavaSerializationProtocol(classLoaderRepository);
    }

    @Override
    public SerializationProtocol getInternalProtocol() {
        return this.javaInternalSerializerProtocol;
    }

    @Override
    public SerializationProtocol getExternalProtocol() {
        return this.javaExternalSerializerProtocol;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void initialise() throws InitialisationException {
        try {
            this.muleContext.getInjector().inject(this.javaInternalSerializerProtocol);
            this.muleContext.getInjector().inject(this.javaExternalSerializerProtocol);
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }
}

