/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ResolverSetBasedObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public abstract class ConnectionProviderObjectBuilder<C>
extends ResolverSetBasedObjectBuilder<Pair<ConnectionProvider<C>, ResolverSetResult>> {
    protected final ConnectionProviderModel providerModel;
    protected final ReconnectionConfig reconnectionConfig;
    protected final PoolingProfile poolingProfile;
    protected final ExtensionModel extensionModel;
    protected final MuleContext muleContext;
    protected String ownerConfigName;

    public ConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, ResolverSet resolverSet, ExtensionModel extensionModel, MuleContext muleContext) {
        this(providerModel, resolverSet, null, null, extensionModel, muleContext);
    }

    public ConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, ResolverSet resolverSet, PoolingProfile poolingProfile, ReconnectionConfig reconnectionConfig, ExtensionModel extensionModel, MuleContext muleContext) {
        super(MuleExtensionUtils.getConnectionProviderFactory(providerModel).getObjectType(), providerModel, resolverSet);
        this.providerModel = providerModel;
        this.poolingProfile = poolingProfile;
        this.extensionModel = extensionModel;
        this.muleContext = muleContext;
        this.reconnectionConfig = this.computeReconnectionConfig(reconnectionConfig);
    }

    private ReconnectionConfig computeReconnectionConfig(ReconnectionConfig reconnectionConfig) {
        return reconnectionConfig != null ? reconnectionConfig : ReconnectionConfig.getDefault();
    }

    public ConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, Class<?> prototypeClass, ResolverSet resolverSet, PoolingProfile poolingProfile, ReconnectionConfig reconnectionConfig, ExtensionModel extensionModel, MuleContext muleContext) {
        super(prototypeClass, providerModel, resolverSet);
        this.providerModel = providerModel;
        this.poolingProfile = poolingProfile;
        this.extensionModel = extensionModel;
        this.muleContext = muleContext;
        this.reconnectionConfig = this.computeReconnectionConfig(reconnectionConfig);
    }

    @Override
    protected Pair<ConnectionProvider<C>, ResolverSetResult> instantiateObject() {
        return new Pair(MuleExtensionUtils.getConnectionProviderFactory(this.providerModel).newInstance(), null);
    }

    @Override
    public Pair<ConnectionProvider<C>, ResolverSetResult> build(ResolverSetResult result) throws MuleException {
        ConnectionProvider value = (ConnectionProvider)((Pair)this.instantiateObject()).getFirst();
        this.populate(result, value);
        return new Pair<ConnectionProvider<C>, ResolverSetResult>(value, result);
    }

    @Override
    public boolean isDynamic() {
        return this.resolverSet.isDynamic();
    }

    public void setOwnerConfigName(String ownerConfigName) {
        this.ownerConfigName = ownerConfigName;
    }
}

