/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.tx.TransactionHandle;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.transaction.DefaultTransactionHandle;
import org.mule.runtime.module.extension.internal.runtime.transaction.NullTransactionHandle;

class DefaultSourceCallbackContext
implements SourceCallbackContextAdapter {
    private static final TransactionHandle NULL_TRANSACTION_HANDLE = new NullTransactionHandle();
    private static final TransactionHandle DEFAULT_TRANSACTION_HANDLE = new DefaultTransactionHandle();
    private final SourceCallbackAdapter sourceCallback;
    private final Map<String, Object> variables = new HashMap<String, Object>();
    private Object connection = null;
    private TransactionHandle transactionHandle = NULL_TRANSACTION_HANDLE;

    DefaultSourceCallbackContext(SourceCallbackAdapter sourceCallback) {
        this.sourceCallback = sourceCallback;
    }

    @Override
    public TransactionHandle bindConnection(Object connection) throws ConnectionException, TransactionException {
        Preconditions.checkArgument(connection != null, "Cannot bind a null connection");
        if (this.connection != null) {
            throw new IllegalArgumentException("Connection can only be set once per " + SourceCallbackContext.class.getSimpleName());
        }
        this.connection = connection;
        if (this.sourceCallback.getTransactionConfig().isTransacted() && connection instanceof TransactionalConnection) {
            ConnectionHandler<Object> connectionHandler = this.sourceCallback.getSourceConnectionManager().getConnectionHandler(connection).orElseThrow(() -> new TransactionException(this.createWrongConnectionMessage(connection)));
            this.sourceCallback.getTransactionSourceBinder().bindToTransaction(this.sourceCallback.getTransactionConfig(), this.sourceCallback.getConfigurationInstance(), connectionHandler);
            this.transactionHandle = DEFAULT_TRANSACTION_HANDLE;
        }
        return this.transactionHandle;
    }

    @Override
    public <T> T getConnection() {
        if (this.connection == null) {
            throw new IllegalArgumentException("No connection has been bound");
        }
        return (T)this.connection;
    }

    @Override
    public void releaseConnection() {
        if (this.connection != null) {
            this.sourceCallback.getSourceConnectionManager().release(this.connection);
        }
    }

    @Override
    public TransactionHandle getTransactionHandle() {
        return this.transactionHandle;
    }

    @Override
    public boolean hasVariable(String variableName) {
        return this.variables.containsKey(variableName);
    }

    @Override
    public <T> Optional<T> getVariable(String variableName) {
        return Optional.ofNullable(this.variables.get(variableName));
    }

    @Override
    public void addVariable(String variableName, Object value) {
        this.variables.put(variableName, value);
    }

    @Override
    public <T, A> SourceCallback<T, A> getSourceCallback() {
        return this.sourceCallback;
    }

    private I18nMessage createWrongConnectionMessage(Object connection) {
        return I18nMessageFactory.createStaticMessage(String.format("Internal Error. The transacted source [%s] from the Extension [%s] tried to bind an connection of type [%s] which is not a connection created by this extension. ", this.sourceCallback.getOwningSourceName(), this.sourceCallback.getOwningExtensionName(), connection.getClass().getName()));
    }
}

