/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.aop.framework;

import java.io.Serializable;
import org.springframework.AAA.aop.SpringProxy;
import org.springframework.AAA.aop.framework.AdvisedSupport;
import org.springframework.AAA.aop.framework.AopConfigException;
import org.springframework.AAA.aop.framework.AopProxy;
import org.springframework.AAA.aop.framework.AopProxyFactory;
import org.springframework.AAA.aop.framework.JdkDynamicAopProxy;
import org.springframework.AAA.aop.framework.ObjenesisCglibAopProxy;

public class DefaultAopProxyFactory
implements AopProxyFactory,
Serializable {
    @Override
    public AopProxy createAopProxy(AdvisedSupport config) throws AopConfigException {
        if (config.isOptimize() || config.isProxyTargetClass() || this.hasNoUserSuppliedProxyInterfaces(config)) {
            Class<?> targetClass = config.getTargetClass();
            if (targetClass == null) {
                throw new AopConfigException("TargetSource cannot determine target class: Either an interface or a target is required for proxy creation.");
            }
            if (targetClass.isInterface()) {
                return new JdkDynamicAopProxy(config);
            }
            return new ObjenesisCglibAopProxy(config);
        }
        return new JdkDynamicAopProxy(config);
    }

    private boolean hasNoUserSuppliedProxyInterfaces(AdvisedSupport config) {
        Class<?>[] interfaces = config.getProxiedInterfaces();
        return interfaces.length == 0 || interfaces.length == 1 && SpringProxy.class.equals(interfaces[0]);
    }
}

