/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.aop.framework.autoproxy;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.AAA.aop.Advisor;
import org.springframework.AAA.beans.factory.BeanCreationException;
import org.springframework.AAA.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.AAA.beans.factory.BeanFactoryUtils;
import org.springframework.AAA.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.AAA.util.Assert;

public class BeanFactoryAdvisorRetrievalHelper {
    private static final Log logger = LogFactory.getLog(BeanFactoryAdvisorRetrievalHelper.class);
    private final ConfigurableListableBeanFactory beanFactory;
    private String[] cachedAdvisorBeanNames;

    public BeanFactoryAdvisorRetrievalHelper(ConfigurableListableBeanFactory beanFactory) {
        Assert.notNull(beanFactory, "ListableBeanFactory must not be null");
        this.beanFactory = beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Advisor> findAdvisorBeans() {
        String[] advisorNames = null;
        BeanFactoryAdvisorRetrievalHelper beanFactoryAdvisorRetrievalHelper = this;
        synchronized (beanFactoryAdvisorRetrievalHelper) {
            advisorNames = this.cachedAdvisorBeanNames;
            if (advisorNames == null) {
                this.cachedAdvisorBeanNames = advisorNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(this.beanFactory, Advisor.class, true, false);
            }
        }
        if (advisorNames.length == 0) {
            return new LinkedList<Advisor>();
        }
        LinkedList<Advisor> advisors = new LinkedList<Advisor>();
        for (String name : advisorNames) {
            if (!this.isEligibleBean(name)) continue;
            if (this.beanFactory.isCurrentlyInCreation(name)) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Skipping currently created advisor '" + name + "'");
                continue;
            }
            try {
                advisors.add(this.beanFactory.getBean(name, Advisor.class));
            }
            catch (BeanCreationException ex) {
                BeanCreationException bce;
                Throwable rootCause = ex.getMostSpecificCause();
                if (rootCause instanceof BeanCurrentlyInCreationException && this.beanFactory.isCurrentlyInCreation((bce = (BeanCreationException)rootCause).getBeanName())) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Skipping advisor '" + name + "' with dependency on currently created bean: " + ex.getMessage());
                    continue;
                }
                throw ex;
            }
        }
        return advisors;
    }

    protected boolean isEligibleBean(String beanName) {
        return true;
    }
}

