/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.beans.factory.annotation;

import org.springframework.AAA.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.AAA.beans.factory.support.GenericBeanDefinition;
import org.springframework.AAA.core.type.AnnotationMetadata;
import org.springframework.AAA.core.type.MethodMetadata;
import org.springframework.AAA.core.type.StandardAnnotationMetadata;
import org.springframework.AAA.util.Assert;

public class AnnotatedGenericBeanDefinition
extends GenericBeanDefinition
implements AnnotatedBeanDefinition {
    private final AnnotationMetadata metadata;
    private MethodMetadata factoryMethodMetadata;

    public AnnotatedGenericBeanDefinition(Class<?> beanClass) {
        this.setBeanClass(beanClass);
        this.metadata = new StandardAnnotationMetadata(beanClass, true);
    }

    public AnnotatedGenericBeanDefinition(AnnotationMetadata metadata) {
        Assert.notNull(metadata, "AnnotationMetadata must not be null");
        if (metadata instanceof StandardAnnotationMetadata) {
            this.setBeanClass(((StandardAnnotationMetadata)metadata).getIntrospectedClass());
        } else {
            this.setBeanClassName(metadata.getClassName());
        }
        this.metadata = metadata;
    }

    public AnnotatedGenericBeanDefinition(AnnotationMetadata metadata, MethodMetadata factoryMethodMetadata) {
        this(metadata);
        Assert.notNull(factoryMethodMetadata, "MethodMetadata must not be null");
        this.setFactoryMethodName(factoryMethodMetadata.getMethodName());
        this.factoryMethodMetadata = factoryMethodMetadata;
    }

    @Override
    public final AnnotationMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public final MethodMetadata getFactoryMethodMetadata() {
        return this.factoryMethodMetadata;
    }
}

