/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.cache.interceptor;

import java.lang.reflect.Method;
import org.springframework.AAA.util.Assert;
import org.springframework.AAA.util.ObjectUtils;

public final class MethodCacheKey {
    private final Method method;
    private final Class<?> targetClass;

    public MethodCacheKey(Method method, Class<?> targetClass) {
        Assert.notNull(method, "method must be set.");
        this.method = method;
        this.targetClass = targetClass;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MethodCacheKey)) {
            return false;
        }
        MethodCacheKey otherKey = (MethodCacheKey)other;
        return this.method.equals(otherKey.method) && ObjectUtils.nullSafeEquals(this.targetClass, otherKey.targetClass);
    }

    public int hashCode() {
        return this.method.hashCode() + (this.targetClass != null ? this.targetClass.hashCode() * 29 : 0);
    }
}

