/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.cglib.transform.impl;

import java.lang.reflect.Method;
import org.springframework.AAA.asm.Type;
import org.springframework.AAA.cglib.core.CodeEmitter;
import org.springframework.AAA.cglib.core.Constants;
import org.springframework.AAA.cglib.core.EmitUtils;
import org.springframework.AAA.cglib.core.MethodInfo;
import org.springframework.AAA.cglib.core.ReflectUtils;
import org.springframework.AAA.cglib.core.TypeUtils;
import org.springframework.AAA.cglib.transform.ClassEmitterTransformer;

public class AddStaticInitTransformer
extends ClassEmitterTransformer {
    private MethodInfo info;

    public AddStaticInitTransformer(Method classInit) {
        this.info = ReflectUtils.getMethodInfo(classInit);
        if (!TypeUtils.isStatic(this.info.getModifiers())) {
            throw new IllegalArgumentException(classInit + " is not static");
        }
        Type[] types = this.info.getSignature().getArgumentTypes();
        if (types.length != 1 || !types[0].equals(Constants.TYPE_CLASS) || !this.info.getSignature().getReturnType().equals(Type.VOID_TYPE)) {
            throw new IllegalArgumentException(classInit + " illegal signature");
        }
    }

    protected void init() {
        if (!TypeUtils.isInterface(this.getAccess())) {
            CodeEmitter e = this.getStaticHook();
            EmitUtils.load_class_this(e);
            e.invoke(this.info);
        }
    }
}

