/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.context.access;

import java.util.HashMap;
import java.util.Map;
import org.springframework.AAA.beans.BeansException;
import org.springframework.AAA.beans.factory.BeanFactory;
import org.springframework.AAA.beans.factory.access.BeanFactoryLocator;
import org.springframework.AAA.beans.factory.access.SingletonBeanFactoryLocator;
import org.springframework.AAA.context.ConfigurableApplicationContext;
import org.springframework.AAA.context.support.ClassPathXmlApplicationContext;
import org.springframework.AAA.core.io.support.ResourcePatternUtils;

public class ContextSingletonBeanFactoryLocator
extends SingletonBeanFactoryLocator {
    private static final String DEFAULT_RESOURCE_LOCATION = "classpath*:beanRefContext.xml";
    private static final Map<String, BeanFactoryLocator> instances = new HashMap<String, BeanFactoryLocator>();

    public static BeanFactoryLocator getInstance() throws BeansException {
        return ContextSingletonBeanFactoryLocator.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanFactoryLocator getInstance(String selector) throws BeansException {
        String resourceLocation = selector;
        if (resourceLocation == null) {
            resourceLocation = DEFAULT_RESOURCE_LOCATION;
        }
        if (!ResourcePatternUtils.isUrl(resourceLocation)) {
            resourceLocation = "classpath*:" + resourceLocation;
        }
        Map<String, BeanFactoryLocator> map = instances;
        synchronized (map) {
            BeanFactoryLocator bfl;
            if (logger.isTraceEnabled()) {
                logger.trace("ContextSingletonBeanFactoryLocator.getInstance(): instances.hashCode=" + instances.hashCode() + ", instances=" + instances);
            }
            if ((bfl = instances.get(resourceLocation)) == null) {
                bfl = new ContextSingletonBeanFactoryLocator(resourceLocation);
                instances.put(resourceLocation, bfl);
            }
            return bfl;
        }
    }

    protected ContextSingletonBeanFactoryLocator(String resourceLocation) {
        super(resourceLocation);
    }

    @Override
    protected BeanFactory createDefinition(String resourceLocation, String factoryKey) {
        return new ClassPathXmlApplicationContext(new String[]{resourceLocation}, false);
    }

    @Override
    protected void initializeDefinition(BeanFactory groupDef) {
        if (groupDef instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)groupDef).refresh();
        }
    }

    @Override
    protected void destroyDefinition(BeanFactory groupDef, String selector) {
        if (groupDef instanceof ConfigurableApplicationContext) {
            if (logger.isTraceEnabled()) {
                logger.trace("Context group with selector '" + selector + "' being released, as there are no more references to it");
            }
            ((ConfigurableApplicationContext)groupDef).close();
        }
    }
}

