/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.expression.spel.ast;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.springframework.AAA.asm.MethodVisitor;
import org.springframework.AAA.expression.EvaluationException;
import org.springframework.AAA.expression.Operation;
import org.springframework.AAA.expression.TypedValue;
import org.springframework.AAA.expression.spel.CodeFlow;
import org.springframework.AAA.expression.spel.ExpressionState;
import org.springframework.AAA.expression.spel.ast.Operator;
import org.springframework.AAA.expression.spel.ast.SpelNodeImpl;
import org.springframework.AAA.util.NumberUtils;

public class OpDivide
extends Operator {
    public OpDivide(int pos, SpelNodeImpl ... operands) {
        super("/", pos, operands);
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        Object leftOperand = this.getLeftOperand().getValueInternal(state).getValue();
        Object rightOperand = this.getRightOperand().getValueInternal(state).getValue();
        if (leftOperand instanceof Number && rightOperand instanceof Number) {
            Number leftNumber = (Number)leftOperand;
            Number rightNumber = (Number)rightOperand;
            if (leftNumber instanceof BigDecimal || rightNumber instanceof BigDecimal) {
                BigDecimal leftBigDecimal = NumberUtils.convertNumberToTargetClass(leftNumber, BigDecimal.class);
                BigDecimal rightBigDecimal = NumberUtils.convertNumberToTargetClass(rightNumber, BigDecimal.class);
                int scale = Math.max(leftBigDecimal.scale(), rightBigDecimal.scale());
                return new TypedValue(leftBigDecimal.divide(rightBigDecimal, scale, RoundingMode.HALF_EVEN));
            }
            if (leftNumber instanceof Double || rightNumber instanceof Double) {
                if (leftNumber.getClass() == rightNumber.getClass()) {
                    this.exitTypeDescriptor = "D";
                }
                return new TypedValue(leftNumber.doubleValue() / rightNumber.doubleValue());
            }
            if (leftNumber instanceof Float || rightNumber instanceof Float) {
                if (leftNumber.getClass() == rightNumber.getClass()) {
                    this.exitTypeDescriptor = "F";
                }
                return new TypedValue(Float.valueOf(leftNumber.floatValue() / rightNumber.floatValue()));
            }
            if (leftNumber instanceof BigInteger || rightNumber instanceof BigInteger) {
                BigInteger leftBigInteger = NumberUtils.convertNumberToTargetClass(leftNumber, BigInteger.class);
                BigInteger rightBigInteger = NumberUtils.convertNumberToTargetClass(rightNumber, BigInteger.class);
                return new TypedValue(leftBigInteger.divide(rightBigInteger));
            }
            if (leftNumber instanceof Long || rightNumber instanceof Long) {
                if (leftNumber.getClass() == rightNumber.getClass()) {
                    this.exitTypeDescriptor = "J";
                }
                return new TypedValue(leftNumber.longValue() / rightNumber.longValue());
            }
            if (CodeFlow.isIntegerForNumericOp(leftNumber) || CodeFlow.isIntegerForNumericOp(rightNumber)) {
                if (leftNumber instanceof Integer && rightNumber instanceof Integer) {
                    this.exitTypeDescriptor = "I";
                }
                return new TypedValue(leftNumber.intValue() / rightNumber.intValue());
            }
            return new TypedValue(leftNumber.doubleValue() / rightNumber.doubleValue());
        }
        return state.operate(Operation.DIVIDE, leftOperand, rightOperand);
    }

    @Override
    public boolean isCompilable() {
        if (!this.getLeftOperand().isCompilable()) {
            return false;
        }
        if (this.children.length > 1 && !this.getRightOperand().isCompilable()) {
            return false;
        }
        return this.exitTypeDescriptor != null;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        this.getLeftOperand().generateCode(mv, cf);
        String leftDesc = this.getLeftOperand().exitTypeDescriptor;
        if (!CodeFlow.isPrimitive(leftDesc)) {
            CodeFlow.insertUnboxInsns(mv, this.exitTypeDescriptor.charAt(0), leftDesc);
        }
        if (this.children.length > 1) {
            cf.enterCompilationScope();
            this.getRightOperand().generateCode(mv, cf);
            String rightDesc = this.getRightOperand().exitTypeDescriptor;
            cf.exitCompilationScope();
            if (!CodeFlow.isPrimitive(rightDesc)) {
                CodeFlow.insertUnboxInsns(mv, this.exitTypeDescriptor.charAt(0), rightDesc);
            }
            switch (this.exitTypeDescriptor.charAt(0)) {
                case 'I': {
                    mv.visitInsn(108);
                    break;
                }
                case 'J': {
                    mv.visitInsn(109);
                    break;
                }
                case 'F': {
                    mv.visitInsn(110);
                    break;
                }
                case 'D': {
                    mv.visitInsn(111);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized exit type descriptor: '" + this.exitTypeDescriptor + "'");
                }
            }
        }
        cf.pushDescriptor(this.exitTypeDescriptor);
    }
}

