/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.api;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.mule.connectivity.exception.BuilderException;
import org.mule.connectivity.exception.GenerationException;
import org.mule.connectivity.model.ConnectorCategory;
import org.mule.connectivity.model.MavenDependency;
import org.mule.connectivity.model.api.RestConnectAPIModel;

public class RestConnectModelBuilder {
    private String apiName;
    private File raml;
    private String groupId;
    private String artifactId;
    private String version;
    private String customPackage;
    private ConnectorCategory category;
    private List<MavenDependency> dependencies = new ArrayList<MavenDependency>();
    private String projectDescription;
    private String rootDir;

    private RestConnectModelBuilder() {
    }

    public static RestConnectModelBuilder createModel() {
        return new RestConnectModelBuilder();
    }

    public RestConnectModelBuilder withName(String apiName) {
        this.apiName = apiName;
        return this;
    }

    public RestConnectModelBuilder fromRaml(File raml) {
        this.raml = raml;
        return this;
    }

    public RestConnectModelBuilder fromRaml(String ramlFileName) {
        this.raml = new File(ramlFileName);
        return this;
    }

    public RestConnectModelBuilder withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public RestConnectModelBuilder withArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public RestConnectModelBuilder withVersion(String version) {
        this.version = version;
        return this;
    }

    public RestConnectModelBuilder withCategory(ConnectorCategory category) {
        this.category = category;
        return this;
    }

    public RestConnectModelBuilder withCustomPackage(String customPackage) {
        this.customPackage = customPackage;
        return this;
    }

    public RestConnectModelBuilder withCategory(String category) {
        this.category = ConnectorCategory.fromString(category);
        return this;
    }

    public RestConnectModelBuilder withDependency(MavenDependency dependency) {
        this.dependencies.add(dependency);
        return this;
    }

    public RestConnectModelBuilder withProjectDescription(String description) {
        this.projectDescription = description;
        return this;
    }

    public RestConnectModelBuilder withRootDir(String rootDir) {
        this.rootDir = rootDir;
        return this;
    }

    public String getApiName() {
        return this.apiName;
    }

    public File getRaml() {
        return this.raml;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCustomPackage() {
        return this.customPackage;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public List<MavenDependency> getDependencies() {
        return this.dependencies;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public ConnectorCategory getCategory() {
        return this.category;
    }

    public RestConnectAPIModel build() throws GenerationException {
        if (this.getRaml() == null) {
            throw new BuilderException("RAML file wasn't provided.");
        }
        return new RestConnectAPIModel(this);
    }
}

