/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.uri;

import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.mule.connectivity.exception.GenerationException;
import org.mule.connectivity.model.uri.BaseUri;
import org.raml.v2.api.model.v10.api.Api;

public class BaseUriBuilder {
    public static final String VERSION_URI_PARAM = "{version}";
    public static final String VERSION_URI_PARAM_REGEX = "\\{version\\}";

    private static String buildBaseUriString(Api api) {
        if (api.baseUri() == null) {
            return "";
        }
        if (api.baseUri().value().contains(VERSION_URI_PARAM) && api.version() != null && !api.version().value().isEmpty()) {
            return api.baseUri().value().replaceAll(VERSION_URI_PARAM_REGEX, api.version().value());
        }
        if (api.baseUri().value().contains(VERSION_URI_PARAM)) {
            return "";
        }
        return api.baseUri().value();
    }

    public static BaseUri buildBaseUri(Api api) throws GenerationException {
        String baseUriString = BaseUriBuilder.buildBaseUriString(api);
        if (StringUtils.isBlank((String)baseUriString)) {
            return null;
        }
        if (baseUriString.endsWith("/")) {
            baseUriString = StringUtils.chop((String)baseUriString);
        }
        try {
            BaseUri uri = new BaseUri(baseUriString);
            if (!uri.isAbsolute()) {
                return null;
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new GenerationException("Invalid base URI.", e);
        }
    }
}

