/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.util;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.model.parameter.FixedValueTypeDefinition;
import org.mule.connectivity.model.parameter.TypeDefinition;
import org.mule.connectivity.util.ParserUtils;

public class DataWeaveUtils {
    public static String getParametersDW(Map<String, TypeDefinition> parameters, Map<String, TypeDefinition> properties) {
        ArrayList<String> keys = new ArrayList<String>();
        if (parameters != null) {
            for (String parameterName : parameters.keySet()) {
                keys.add(DataWeaveUtils.getParameterDWExpression(parameterName, parameters.get(parameterName)));
            }
        }
        if (properties != null) {
            for (String varName : properties.keySet()) {
                keys.add(DataWeaveUtils.getParameterDWExpression(varName, properties.get(varName), "property_"));
            }
        }
        return String.format("#[ { %s } filterObject $ != null ]", StringUtils.join(keys, (String)","));
    }

    private static String getParameterDWExpression(String name, TypeDefinition typeDefinition) {
        return DataWeaveUtils.getParameterDWExpression(name, typeDefinition, "");
    }

    private static String getParameterDWExpression(String name, TypeDefinition typeDefinition, String prefix) {
        if (typeDefinition.getClass().equals(FixedValueTypeDefinition.class)) {
            return String.format("'%s': '" + ((FixedValueTypeDefinition)typeDefinition).getFixedValue() + "'", name);
        }
        return String.format("'%s': vars['" + prefix + "%s']", name, ParserUtils.getXmlName(name));
    }
}

