/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.security;

import java.util.ArrayList;
import java.util.List;
import org.mule.connectivity.exception.UnsupportedSecuritySchemeException;
import org.mule.connectivity.model.security.APISecurityScheme;
import org.mule.connectivity.model.security.BasicAuthScheme;
import org.mule.connectivity.model.security.DigestAuthenticationScheme;
import org.mule.connectivity.model.security.OAuth2AuthorizationCodeScheme;
import org.mule.connectivity.model.security.OAuth2ClientCredentialsScheme;
import org.mule.connectivity.model.security.PassThroughScheme;
import org.mule.connectivity.model.security.UnsecuredScheme;
import org.raml.v2.api.model.v10.security.SecurityScheme;

public class SecuritySchemeFactory {
    public static List<APISecurityScheme> getSchemes(List<SecurityScheme> securitySchemes) throws UnsupportedSecuritySchemeException {
        ArrayList<APISecurityScheme> apiSecuritySchemes = new ArrayList<APISecurityScheme>();
        for (SecurityScheme securityScheme : securitySchemes) {
            List<APISecurityScheme> apiSecuritySchemesAux = SecuritySchemeFactory.createSecuritySchemes(securityScheme);
            for (APISecurityScheme apiSecurityScheme : apiSecuritySchemesAux) {
                apiSecuritySchemes.add(apiSecurityScheme);
            }
        }
        if (!securitySchemes.isEmpty() && apiSecuritySchemes.isEmpty()) {
            throw new UnsupportedSecuritySchemeException("None of the specified security schemes ( " + SecuritySchemeFactory.listSchemes(securitySchemes) + ") are supported.");
        }
        if (securitySchemes.isEmpty()) {
            apiSecuritySchemes.add(new UnsecuredScheme());
        }
        return apiSecuritySchemes;
    }

    private static List<APISecurityScheme> createSecuritySchemes(SecurityScheme securityScheme) {
        ArrayList<APISecurityScheme> apiSecuritySchemes = new ArrayList<APISecurityScheme>();
        switch (securityScheme.type()) {
            case "Basic Authentication": {
                apiSecuritySchemes.add(new BasicAuthScheme());
                return apiSecuritySchemes;
            }
            case "Pass Through": {
                apiSecuritySchemes.add(new PassThroughScheme(securityScheme));
                return apiSecuritySchemes;
            }
            case "OAuth 2.0": {
                for (String grant : securityScheme.settings().authorizationGrants()) {
                    if (grant.equals("authorization_code")) {
                        apiSecuritySchemes.add(new OAuth2AuthorizationCodeScheme(securityScheme));
                        continue;
                    }
                    if (!grant.equals("client_credentials")) continue;
                    apiSecuritySchemes.add(new OAuth2ClientCredentialsScheme(securityScheme));
                }
                return apiSecuritySchemes;
            }
            case "Digest Authentication": {
                apiSecuritySchemes.add(new DigestAuthenticationScheme());
                return apiSecuritySchemes;
            }
        }
        return apiSecuritySchemes;
    }

    private static String listSchemes(List<SecurityScheme> securitySchemes) {
        StringBuilder builder = new StringBuilder();
        for (SecurityScheme securityScheme : securitySchemes) {
            builder.append(securityScheme.name());
            if (securityScheme.type().equals("OAuth 2.0")) {
                builder.append(" :");
                for (String grant : securityScheme.settings().authorizationGrants()) {
                    builder.append(" ");
                    builder.append(grant);
                }
            }
            builder.append(". ");
        }
        return builder.toString();
    }
}

