/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.internal;

import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import org.everit.json.schema.Schema;
import org.json.JSONWriter;

public class JSONPrinter {
    private final JSONWriter writer;

    public JSONPrinter(Writer writer) {
        this(new JSONWriter(writer));
    }

    public JSONPrinter(JSONWriter writer) {
        this.writer = Objects.requireNonNull(writer, "writer cannot be null");
    }

    public JSONPrinter key(String key) {
        this.writer.key(key);
        return this;
    }

    public JSONPrinter value(Object value) {
        this.writer.value(value);
        return this;
    }

    public JSONPrinter object() {
        this.writer.object();
        return this;
    }

    public JSONPrinter endObject() {
        this.writer.endObject();
        return this;
    }

    public JSONPrinter ifPresent(String key, Object value) {
        if (value != null) {
            this.key(key);
            this.value(value);
        }
        return this;
    }

    public JSONPrinter ifTrue(String key, Boolean value) {
        if (value != null && value.booleanValue()) {
            this.key(key);
            this.value(value);
        }
        return this;
    }

    public JSONPrinter array() {
        this.writer.array();
        return this;
    }

    public JSONPrinter endArray() {
        this.writer.endArray();
        return this;
    }

    public void ifFalse(String key, Boolean value) {
        if (value != null && !value.booleanValue()) {
            this.writer.key(key);
            this.writer.value(value);
        }
    }

    public <K> void printSchemaMap(Map<K, Schema> input) {
        this.object();
        input.entrySet().forEach(entry -> {
            this.key(entry.getKey().toString());
            ((Schema)entry.getValue()).describeTo(this);
        });
        this.endObject();
    }
}

