/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.api;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.connectivity.exception.GenerationException;
import org.mule.connectivity.exception.InvalidRAMLSourceException;
import org.mule.connectivity.exception.UnsupportedSecuritySchemeException;
import org.mule.connectivity.model.ConnectorCategory;
import org.mule.connectivity.model.MavenDependency;
import org.mule.connectivity.model.api.RestConnectModelBuilder;
import org.mule.connectivity.model.operation.Operation;
import org.mule.connectivity.model.security.APISecurityScheme;
import org.mule.connectivity.model.security.SecuritySchemeFactory;
import org.mule.connectivity.util.ExchangeDependencyResourceLoader;
import org.mule.connectivity.util.OperationMappingUtils;
import org.raml.v2.api.RamlModelBuilder;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.loader.CompositeResourceLoader;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.methods.Method;

public class RestConnectAPIModel {
    public static final String DEFAULT_VERSION = "1.0.0";
    public static final String VERSION_URI_PARAM = "{version}";
    public static final String VERSION_URI_PARAM_REGEX = "\\{version\\}";
    private static final Logger logger = LogManager.getLogger(RestConnectAPIModel.class);
    private final Api api;
    private final String apiName;
    private final URI baseUri;
    private final ConnectorCategory category;
    private final String projectDescription;
    private final List<MavenDependency> dependencies;
    private final String rootDir;
    private final List<Operation> operations;
    private final List<APISecurityScheme> securitySchemes;
    private String groupId;
    private String artifactId;
    private String version;
    private String customPackage;

    public RestConnectAPIModel(RestConnectModelBuilder builder) throws GenerationException {
        this.rootDir = this.buildRootDir(builder);
        this.api = this.buildAPI(builder);
        this.apiName = this.buildApiName(builder);
        this.groupId = this.buildGroupId(builder);
        this.artifactId = this.buildArtifactId(builder);
        this.version = this.buildVersion(builder);
        this.customPackage = this.buildCustomPackage(builder);
        this.category = this.buildCategory(builder);
        this.dependencies = this.buildDependencies(builder);
        this.projectDescription = this.buildProjectDescription(builder);
        this.baseUri = this.buildBaseUri();
        this.operations = this.buildOperationsModel();
        this.securitySchemes = this.buildSecurityModel();
    }

    private String buildRootDir(RestConnectModelBuilder builder) {
        return StringUtils.isBlank((String)builder.getRootDir()) ? "." : builder.getRootDir();
    }

    private String buildProjectDescription(RestConnectModelBuilder builder) {
        return builder.getProjectDescription();
    }

    private List<MavenDependency> buildDependencies(RestConnectModelBuilder builder) {
        return builder.getDependencies();
    }

    private ConnectorCategory buildCategory(RestConnectModelBuilder builder) {
        return builder.getCategory();
    }

    private String buildApiName(RestConnectModelBuilder builder) {
        if (!StringUtils.isBlank((String)builder.getApiName())) {
            return builder.getApiName();
        }
        return this.api.title().value();
    }

    private String buildVersion(RestConnectModelBuilder builder) {
        if (!StringUtils.isBlank((String)builder.getVersion())) {
            return builder.getVersion();
        }
        return this.getDefaultVersion();
    }

    private String buildGroupId(RestConnectModelBuilder builder) {
        if (!StringUtils.isBlank((String)builder.getGroupId())) {
            return builder.getGroupId();
        }
        return null;
    }

    private String buildArtifactId(RestConnectModelBuilder builder) {
        if (!StringUtils.isBlank((String)builder.getArtifactId())) {
            return builder.getArtifactId();
        }
        return null;
    }

    private String buildCustomPackage(RestConnectModelBuilder builder) {
        if (!StringUtils.isBlank((String)builder.getCustomPackage())) {
            return builder.getCustomPackage();
        }
        return null;
    }

    private List<APISecurityScheme> buildSecurityModel() throws UnsupportedSecuritySchemeException {
        return SecuritySchemeFactory.getSchemes(this.api.securitySchemes());
    }

    private List<Operation> buildOperationsModel() throws GenerationException {
        List<Method> methods = OperationMappingUtils.getMethods(this.api);
        ArrayList<Operation> operations = new ArrayList<Operation>();
        for (Method method : methods) {
            if (OperationMappingUtils.isIgnored(method)) {
                logger.warn("Resource ignored: {} {}", (Object)method.method(), (Object)method.resource().resourcePath());
                continue;
            }
            operations.add(new Operation(method));
        }
        OperationMappingUtils.disambiguateRepeatedOperations(operations);
        return operations;
    }

    public Api buildAPI(RestConnectModelBuilder builder) {
        return RestConnectAPIModel.getAPIFromRamlFile(builder.getRaml(), builder.getRootDir());
    }

    public static Api getAPIFromRamlFile(File raml, String rootDir) {
        RamlModelResult ramlModelResult;
        CompositeResourceLoader custom = new CompositeResourceLoader(new ResourceLoader[]{new DefaultResourceLoader(), new ExchangeDependencyResourceLoader(rootDir)});
        RamlModelBuilder ramlModelBuilder = new RamlModelBuilder((ResourceLoader)custom);
        try {
            ramlModelResult = ramlModelBuilder.buildApi(raml);
        }
        catch (Exception e) {
            throw new InvalidRAMLSourceException("Invalid RAML: Error in RAML Parser: " + e.getMessage() + ".");
        }
        if (ramlModelResult.hasErrors()) {
            String ramlErrors = StringUtils.join((Collection)ramlModelResult.getValidationResults(), (String)", ");
            throw new InvalidRAMLSourceException("Invalid RAML: " + ramlErrors + ".");
        }
        if (ramlModelResult.isVersion08()) {
            throw new InvalidRAMLSourceException("RAML 0.8 is not supported.");
        }
        if (ramlModelResult.getApiV10() == null) {
            throw new InvalidRAMLSourceException("Invalid RAML: the provided source isn't an API definition but a fragment.");
        }
        return ramlModelResult.getApiV10();
    }

    public List<APISecurityScheme> getSecuritySchemes() {
        return this.securitySchemes;
    }

    private String buildBaseUriString() {
        if (this.api.baseUri() == null || !this.api.baseUriParameters().isEmpty()) {
            return "";
        }
        if (this.api.baseUri().value().contains(VERSION_URI_PARAM) && this.api.version() != null && !this.api.version().value().isEmpty()) {
            return this.api.baseUri().value().replaceAll(VERSION_URI_PARAM_REGEX, this.api.version().value());
        }
        if (this.api.baseUri().value().contains(VERSION_URI_PARAM)) {
            return "";
        }
        return this.api.baseUri().value();
    }

    private URI buildBaseUri() throws GenerationException {
        String baseUriString = this.buildBaseUriString();
        if (StringUtils.isBlank((String)baseUriString)) {
            return null;
        }
        if (baseUriString.endsWith("/")) {
            baseUriString = StringUtils.chop((String)baseUriString);
        }
        try {
            URI uri = new URI(baseUriString);
            if (!uri.isAbsolute()) {
                return null;
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new GenerationException("Invalid base URI.", e);
        }
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getApiDescription() {
        return this.api.description() == null ? "" : this.api.description().value();
    }

    protected String getDefaultVersion() {
        return DEFAULT_VERSION;
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCustomPackage() {
        return this.customPackage;
    }

    public ConnectorCategory getCategory() {
        return this.category;
    }

    public List<MavenDependency> getDependencies() {
        return this.dependencies;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }
}

