/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.templateEngine;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.ToolManager;
import org.mule.connectivity.exception.ExtensionModelGenerationException;
import org.mule.connectivity.exception.UnsupportedSecuritySchemeException;
import org.mule.connectivity.model.api.RestConnectAPIModel;
import org.mule.connectivity.model.security.APISecurityScheme;
import org.mule.connectivity.model.security.BasicAuthScheme;
import org.mule.connectivity.model.security.DigestAuthenticationScheme;
import org.mule.connectivity.model.security.OAuth2Scheme;
import org.mule.connectivity.model.security.PassThroughScheme;
import org.mule.connectivity.templateEngine.ExtensionModelGenerator;
import org.mule.connectivity.templateEngine.SmartConnectorGeneratedSources;
import org.mule.connectivity.templateEngine.TemplateEngine;
import org.mule.connectivity.templateEngine.builder.SmartConnectorTemplateEngineBuilder;
import org.mule.connectivity.templateEngine.decorator.model.SmartConnectorModelDecorator;
import org.mule.connectivity.templateEngine.decorator.operation.SmartConnectorOperationDecorator;
import org.mule.connectivity.templateEngine.decorator.type.SmartConnectorTypeDefinitionDecorator;
import org.mule.connectivity.util.FileGenerationUtils;

public class SmartConnectorTemplateEngine
extends TemplateEngine {
    private static final String SUPPORTS_BASIC_AUTH = "SUPPORTS_BASIC_AUTH";
    private static final String SUPPORTS_PASS_THROUGH = "SUPPORTS_PASS_THROUGH";
    private static final String SUPPORTS_DIGEST_AUTHENTICATION = "SUPPORTS_DIGEST_AUTHENTICATION";
    private static final String SUPPORTS_OAUTH2 = "SUPPORTS_OAUTH2";
    private static final String SUPPORTS_OAUTH2_CLIENT_CREDENTIALS = "SUPPORTS_OAUTH2_CLIENT_CREDENTIALS";
    private static final String SUPPORTS_OAUTH2_AUTHORIZATION_CODE = "SUPPORTS_OAUTH2_AUTHORIZATION_CODE";
    private static final String EXTENSION = "extension";
    private static final String ACTIVE_SECURITY_SCHEME = "activeSecurityScheme";
    private static final String CATALOG_VM = "templates/smartConnector/catalog.vm";
    private static final String MODULE_VM = "templates/smartConnector/module.vm";
    private static final String MULE_ARTIFACT_VM = "templates/smartConnector/mule-artifact.vm";
    private static final String POM_VM = "templates/smartConnector/pom.vm";
    private static final String ICON_PATH = "images/icon.svg";
    private static final Path RESOURCES_DIR = Paths.get("src/main/resources", new String[0]);
    private static final String PROPERTIES_RESOURCE = "/project.properties";
    private static final String APPLICATION_PROPERTIES = "properties";
    private final SmartConnectorModelDecorator model;
    private final APISecurityScheme activeSecurityScheme;
    private final Path outputDir;
    private SmartConnectorGeneratedSources generatedSources;

    public SmartConnectorTemplateEngine(SmartConnectorTemplateEngineBuilder builder) {
        this.model = new SmartConnectorModelDecorator(builder.getModel());
        this.outputDir = builder.getOutputDir();
        this.activeSecurityScheme = this.buildActiveSecurityScheme(builder.getModel());
        this.generatedSources = new SmartConnectorGeneratedSources(this.outputDir);
    }

    private APISecurityScheme buildActiveSecurityScheme(RestConnectAPIModel model) {
        for (APISecurityScheme scheme : model.getSecuritySchemes()) {
            if (!scheme.getSchemeName().equals("Basic Authentication")) continue;
            return scheme;
        }
        for (APISecurityScheme scheme : model.getSecuritySchemes()) {
            if (!scheme.getSchemeName().equals("OAuth 2.0")) continue;
            for (String grant : ((OAuth2Scheme)scheme).getAuthorizationGrants()) {
                if (!grant.equals("client_credentials")) continue;
                return scheme;
            }
        }
        for (APISecurityScheme scheme : model.getSecuritySchemes()) {
            if (!scheme.getSchemeName().equals("OAuth 2.0")) continue;
            for (String grant : ((OAuth2Scheme)scheme).getAuthorizationGrants()) {
                if (!grant.equals("authorization_code")) continue;
                return scheme;
            }
        }
        for (APISecurityScheme scheme : model.getSecuritySchemes()) {
            if (!scheme.getSchemeName().equals("Pass Through")) continue;
            return scheme;
        }
        return model.getSecuritySchemes().get(0);
    }

    @Override
    public void applyTemplates() throws Exception {
        this.generateCatalog();
        this.generateVMTemplates();
        this.generateAssetFiles();
    }

    private void generateAssetFiles() throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Path output = this.outputDir.resolve("icon.svg");
        InputStream stream = classLoader.getResourceAsStream(ICON_PATH);
        byte[] buffer = new byte[stream.available()];
        stream.read(buffer);
        File targetFile = output.toFile();
        FileOutputStream outStream = new FileOutputStream(targetFile);
        ((OutputStream)outStream).write(buffer);
        this.generatedSources.setIcon(output);
    }

    private void generateCatalog() throws IOException {
        Path outputResourcesDir = this.outputDir.resolve(RESOURCES_DIR);
        for (SmartConnectorOperationDecorator operation : this.model.getDecoratedOperations()) {
            if (operation.getDecoratedInputMetadata() != null && operation.getDecoratedInputMetadata().requiresCatalog()) {
                this.generatedSources.getCatalogSchemas().add(operation.getDecoratedInputMetadata().writeSchema(outputResourcesDir));
            }
            if (operation.getDecoratedOutputMetadata() != null && operation.getDecoratedOutputMetadata().requiresCatalog()) {
                this.generatedSources.getCatalogSchemas().add(operation.getDecoratedOutputMetadata().writeSchema(outputResourcesDir));
            }
            for (SmartConnectorTypeDefinitionDecorator parameter : operation.getDecoratedParameters()) {
                if (!parameter.requiresCatalog()) continue;
                this.generatedSources.getCatalogSchemas().add(parameter.writeSchema(outputResourcesDir));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void generateVMTemplates() throws Exception {
        ToolManager velocityToolManager = new ToolManager();
        velocityToolManager.configure("velocity-tools.xml");
        VelocityContext context = new VelocityContext((Context)velocityToolManager.createContext());
        context.internalPut(EXTENSION, (Object)this.model);
        context.internalPut(APPLICATION_PROPERTIES, (Object)this.getApplicationProperties());
        context.internalPut(ACTIVE_SECURITY_SCHEME, (Object)this.activeSecurityScheme);
        if (this.activeSecurityScheme instanceof BasicAuthScheme) {
            context.internalPut(SUPPORTS_BASIC_AUTH, (Object)true);
        } else if (this.activeSecurityScheme instanceof OAuth2Scheme) {
            context.internalPut(SUPPORTS_OAUTH2, (Object)true);
            if (((OAuth2Scheme)this.activeSecurityScheme).supportsAuthorizationGrant("client_credentials")) {
                context.internalPut(SUPPORTS_OAUTH2_CLIENT_CREDENTIALS, (Object)true);
            } else {
                if (!((OAuth2Scheme)this.activeSecurityScheme).supportsAuthorizationGrant("authorization_code")) {
                    String grants = this.getGrants(this.model.getSecuritySchemes());
                    throw new UnsupportedSecuritySchemeException("OAuth 2.0 grant types supported are Client Credentials and Authorization Code ( " + grants + "not supported )");
                }
                context.internalPut(SUPPORTS_OAUTH2_AUTHORIZATION_CODE, (Object)true);
            }
        } else if (this.activeSecurityScheme instanceof PassThroughScheme) {
            context.internalPut(SUPPORTS_PASS_THROUGH, (Object)true);
        } else if (this.activeSecurityScheme instanceof DigestAuthenticationScheme) {
            context.internalPut(SUPPORTS_DIGEST_AUTHENTICATION, (Object)true);
        }
        Path outputResourcesDir = this.outputDir.resolve(RESOURCES_DIR);
        this.generatedSources.setPom(this.applyTemplate(POM_VM, this.outputDir.resolve("pom.xml"), context));
        this.generatedSources.setModule(this.applyTemplate(MODULE_VM, outputResourcesDir.resolve(String.format("module-%s.xml", this.model.getModulePrefix())), context));
        this.generatedSources.setCatalog(this.applyTemplate(CATALOG_VM, outputResourcesDir.resolve(String.format("module-%s-catalog.xml", this.model.getModulePrefix())), context));
        this.generatedSources.setArtifact(this.applyTemplate(MULE_ARTIFACT_VM, this.outputDir.resolve("mule-artifact.json"), context));
    }

    public void packageProject() throws ExtensionModelGenerationException, IOException {
        Path packageFolder = this.outputDir.resolve("package");
        Files.createDirectories(packageFolder, new FileAttribute[0]);
        this.createExtensionModel(packageFolder);
        this.createJarFile(packageFolder);
    }

    private void createExtensionModel(Path packageFolder) throws ExtensionModelGenerationException {
        boolean includeOAuthDependency = this.activeSecurityScheme instanceof OAuth2Scheme;
        ExtensionModelGenerator generator = new ExtensionModelGenerator();
        this.generatedSources.setExtensionModel(generator.generateExtensionModel(this.generatedSources.getModule(), includeOAuthDependency, packageFolder));
    }

    private void createJarFile(Path packageFolder) throws IOException {
        Path jarDir = Files.createTempDirectory("jar-temp", new FileAttribute[0]);
        Path metaInfDir = jarDir.resolve(Paths.get("META-INF", new String[0]));
        metaInfDir.toFile().mkdirs();
        Path muleArtifactDir = metaInfDir.resolve(Paths.get("mule-artifact", new String[0]));
        muleArtifactDir.toFile().mkdirs();
        Path mavenDir = metaInfDir.resolve(Paths.get("maven/" + this.model.getGroupId() + "/" + this.model.getArtifactId(), new String[0]));
        mavenDir.toFile().mkdirs();
        Files.copy(this.generatedSources.getCatalog(), jarDir.resolve(this.generatedSources.getCatalog().getFileName()), new CopyOption[0]);
        Files.copy(this.generatedSources.getModule(), jarDir.resolve(this.generatedSources.getModule().getFileName()), new CopyOption[0]);
        Files.copy(this.generatedSources.getArtifact(), muleArtifactDir.resolve(this.generatedSources.getArtifact().getFileName()), new CopyOption[0]);
        Files.copy(this.generatedSources.getIcon(), muleArtifactDir.resolve(this.generatedSources.getIcon().getFileName()), new CopyOption[0]);
        Files.copy(this.generatedSources.getPom(), mavenDir.resolve(this.generatedSources.getPom().getFileName()), new CopyOption[0]);
        for (Path path : this.generatedSources.getDistinctCatalogSchemas()) {
            Files.copy(path, jarDir.resolve(path.getFileName()), new CopyOption[0]);
        }
        String jarName = String.format("%s-%s-mule-plugin.jar", this.model.getArtifactId(), this.model.getVersion());
        Path outputJarFile = packageFolder.resolve(jarName);
        FileGenerationUtils.generateJarFileFromDirectory(jarDir, outputJarFile);
    }

    private Properties getApplicationProperties() throws IOException {
        try (InputStream input = this.getClass().getResourceAsStream(PROPERTIES_RESOURCE);){
            Properties prop = new Properties();
            prop.load(input);
            Properties properties = prop;
            return properties;
        }
    }

    private String getGrants(List<APISecurityScheme> schemas) {
        ArrayList<String> grants = new ArrayList<String>();
        for (APISecurityScheme schema : schemas) {
            if (!(schema instanceof OAuth2Scheme)) continue;
            for (String grant : ((OAuth2Scheme)schema).getAuthorizationGrants()) {
                grants.add(grant);
            }
        }
        return StringUtils.join(grants, (String)", ");
    }
}

