/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.util;

import java.io.File;
import java.io.FilenameFilter;
import net.lingala.zip4j.exception.ZipException;
import org.mule.connectivity.exception.InvalidRAMLSourceException;
import org.mule.connectivity.util.FileUtils;

public class MojoUtils {
    private MojoUtils() {
    }

    public static File getMainRamlFile(String ramlFileName) {
        File raml = new File(ramlFileName);
        if (raml.getName().toLowerCase().endsWith(".zip")) {
            try {
                File tempDir = FileUtils.unzipFile(raml);
                raml = MojoUtils.getRamlFile(tempDir);
            }
            catch (ZipException e) {
                throw new InvalidRAMLSourceException("Invalid zip file.");
            }
        }
        return raml.getAbsoluteFile();
    }

    private static File getRamlFile(File dir) {
        File[] ramlFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".raml");
            }
        });
        if (ramlFiles.length == 0) {
            throw new InvalidRAMLSourceException("The provided zip file doesn't contain any RAML files.");
        }
        if (ramlFiles.length > 1) {
            throw new InvalidRAMLSourceException("The provided zip file contains more than one RAML file.");
        }
        return ramlFiles[0];
    }
}

