/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MultiMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = -4723226524524565104L;
    protected Map<K, LinkedList<V>> paramsMap;

    public MultiMap(MultiMap<K, V> multiMap) {
        this.paramsMap = new LinkedHashMap<K, LinkedList<LinkedList<V>>>(multiMap.paramsMap);
    }

    public MultiMap(Map<K, V> parametersMap) {
        this.paramsMap = parametersMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            LinkedList values = new LinkedList();
            if (e.getValue() instanceof Collection) {
                values.addAll((Collection)e.getValue());
            } else {
                values.add(e.getValue());
            }
            return values;
        }));
        this.paramsMap = Collections.unmodifiableMap(this.paramsMap);
    }

    public MultiMap() {
        this.paramsMap = new LinkedHashMap<K, LinkedList<V>>();
    }

    public MultiMap<K, V> toImmutableMultiMap() {
        return new MultiMap<K, LinkedList<V>>(this.paramsMap);
    }

    @Override
    public int size() {
        return this.paramsMap.values().stream().reduce(0, (count, list) -> list.size() + count, (count, list) -> count);
    }

    @Override
    public boolean isEmpty() {
        return this.paramsMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.paramsMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.paramsMap.values().stream().anyMatch(list -> list.contains(value));
    }

    @Override
    public V get(Object key) {
        LinkedList<V> values = this.paramsMap.get(key);
        if (values != null) {
            return values.getFirst();
        }
        return null;
    }

    public List<V> getAll(Object key) {
        return this.paramsMap.containsKey(key) ? Collections.unmodifiableList((List)this.paramsMap.get(key)) : Collections.emptyList();
    }

    @Override
    public V put(K key, V value) {
        LinkedList<V> previousValue = this.paramsMap.get(key);
        LinkedList<Object> newValue = previousValue;
        if (previousValue != null) {
            previousValue = new LinkedList<V>(previousValue);
        } else {
            newValue = new LinkedList();
        }
        newValue.add(value);
        this.paramsMap.put(key, newValue);
        if (previousValue == null || previousValue.isEmpty()) {
            return null;
        }
        return previousValue.getFirst();
    }

    @Override
    public void put(K key, Collection<V> values) {
        LinkedList<Object> newValue = this.paramsMap.get(key);
        if (newValue == null) {
            newValue = new LinkedList();
        }
        newValue.addAll(values);
        this.paramsMap.put(key, newValue);
    }

    @Override
    public V remove(Object key) {
        Collection values = this.paramsMap.remove(key);
        if (values != null) {
            return (V)values.iterator().next();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> aMap) {
        aMap.forEach((key, value) -> {
            LinkedList<Object> values = new LinkedList<Object>();
            values.add(value);
            this.paramsMap.put(key, values);
        });
    }

    @Override
    public void clear() {
        this.paramsMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.paramsMap.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList();
        this.paramsMap.forEach((key, value) -> values.add(value.getFirst()));
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet entries = new HashSet();
        this.paramsMap.forEach((key, value) -> entries.add(new AbstractMap.SimpleEntry(key, value.getFirst())));
        return entries;
    }

    public List<Map.Entry<K, V>> entryList() {
        LinkedList entries = new LinkedList();
        this.paramsMap.forEach((key, values) -> values.forEach((? super T value) -> entries.add(new AbstractMap.SimpleEntry<Object, Object>(key, value))));
        return entries;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof MultiMap && this.paramsMap.equals(((MultiMap)o).paramsMap);
    }

    @Override
    public int hashCode() {
        return this.paramsMap.hashCode();
    }

    public Map<K, ? extends List<V>> toListValuesMap() {
        return Collections.unmodifiableMap(this.paramsMap);
    }

    public String toString() {
        return "MultiMap{" + Arrays.toString(this.paramsMap.entrySet().toArray()) + '}';
    }
}

