/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.ioc.ConfigurableObjectProvider;
import org.mule.runtime.api.ioc.ObjectProvider;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.config.api.XmlConfigurationDocumentLoader;
import org.mule.runtime.config.api.dsl.CoreDslConstants;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.api.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.api.dsl.processor.ConfigFile;
import org.mule.runtime.config.api.dsl.processor.ConfigLine;
import org.mule.runtime.config.api.dsl.processor.SimpleConfigAttribute;
import org.mule.runtime.config.api.dsl.processor.xml.XmlApplicationParser;
import org.mule.runtime.config.api.dsl.processor.xml.XmlApplicationServiceRegistry;
import org.mule.runtime.config.internal.ImmutableObjectProviderConfiguration;
import org.mule.runtime.config.internal.MuleArtifactObjectProvider;
import org.mule.runtime.config.internal.MuleConfigurationConfigurator;
import org.mule.runtime.config.internal.MuleContextPostProcessor;
import org.mule.runtime.config.internal.ObjectProviderAwareBeanFactory;
import org.mule.runtime.config.internal.OptionalObjectsController;
import org.mule.runtime.config.internal.SpringConfigurationComponentLocator;
import org.mule.runtime.config.internal.SpringMuleContextServiceConfigurator;
import org.mule.runtime.config.internal.dsl.model.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.dsl.model.ConfigurationDependencyResolver;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.model.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.config.RuntimeConfigurationException;
import org.mule.runtime.config.internal.dsl.model.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionFactory;
import org.mule.runtime.config.internal.dsl.spring.ComponentModelHelper;
import org.mule.runtime.config.internal.editors.MulePropertyEditorRegistrar;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.config.internal.parsers.generic.AutoIdUtils;
import org.mule.runtime.config.internal.processor.ComponentLocatorCreatePostProcessor;
import org.mule.runtime.config.internal.processor.ContextExclusiveInjectorProcessor;
import org.mule.runtime.config.internal.processor.DiscardedOptionalBeanPostProcessor;
import org.mule.runtime.config.internal.processor.LifecycleStatePostProcessor;
import org.mule.runtime.config.internal.processor.MuleInjectorProcessor;
import org.mule.runtime.config.internal.processor.PostRegistrationActionsPostProcessor;
import org.mule.runtime.config.internal.util.ComponentBuildingDefinitionUtils;
import org.mule.runtime.config.internal.util.LaxInstantiationStrategyWrapper;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigResource;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.registry.DefaultRegistry;
import org.mule.runtime.core.internal.registry.MuleRegistryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.AAA.beans.BeansException;
import org.springframework.AAA.beans.PropertyValue;
import org.springframework.AAA.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.AAA.beans.factory.annotation.RequiredAnnotationBeanPostProcessor;
import org.springframework.AAA.beans.factory.config.BeanDefinition;
import org.springframework.AAA.beans.factory.config.BeanPostProcessor;
import org.springframework.AAA.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.AAA.beans.factory.config.ConstructorArgumentValues;
import org.springframework.AAA.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.AAA.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.AAA.beans.factory.support.CglibSubclassingInstantiationStrategy;
import org.springframework.AAA.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.AAA.beans.factory.support.GenericBeanDefinition;
import org.springframework.AAA.beans.factory.support.ManagedList;
import org.springframework.AAA.beans.factory.support.ManagedMap;
import org.springframework.AAA.beans.factory.support.RootBeanDefinition;
import org.springframework.AAA.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.AAA.context.annotation.ContextAnnotationAutowireCandidateResolver;
import org.springframework.AAA.context.support.AbstractRefreshableConfigApplicationContext;
import org.springframework.AAA.core.io.ByteArrayResource;
import org.springframework.AAA.core.io.Resource;
import org.springframework.AAA.core.io.UrlResource;
import org.w3c.dom.Document;

public class MuleArtifactContext
extends AbstractRefreshableConfigApplicationContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleArtifactContext.class);
    public static final String INNER_BEAN_PREFIX = "(inner bean)";
    protected final ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry = new ComponentBuildingDefinitionRegistry();
    private final OptionalObjectsController optionalObjectsController;
    private final Map<String, String> artifactProperties;
    private final ArtifactDeclaration artifactDeclaration;
    private final XmlConfigurationDocumentLoader xmlConfigurationDocumentLoader;
    private final Optional<ConfigurationProperties> parentConfigurationProperties;
    private final DefaultRegistry serviceDiscoverer;
    private final ConfigurationDependencyResolver dependencyResolver;
    protected ApplicationModel applicationModel;
    protected MuleContextWithRegistries muleContext;
    private ConfigResource[] artifactConfigResources;
    protected BeanDefinitionFactory beanDefinitionFactory;
    private final ServiceRegistry serviceRegistry = new SpiServiceRegistry();
    protected final XmlApplicationParser xmlApplicationParser;
    private ArtifactType artifactType;
    private List<ComponentIdentifier> componentNotSupportedByNewParsers = new ArrayList<ComponentIdentifier>();
    protected SpringConfigurationComponentLocator componentLocator = new SpringConfigurationComponentLocator(componentName -> {
        try {
            BeanDefinition beanDefinition = this.getBeanFactory().getBeanDefinition((String)componentName);
            return beanDefinition.isPrototype();
        }
        catch (NoSuchBeanDefinitionException e) {
            return false;
        }
    });
    protected List<ConfigurableObjectProvider> objectProviders = new ArrayList<ConfigurableObjectProvider>();

    public MuleArtifactContext(MuleContext muleContext, ConfigResource[] artifactConfigResources, ArtifactDeclaration artifactDeclaration, OptionalObjectsController optionalObjectsController, Map<String, String> artifactProperties, ArtifactType artifactType, List<ClassLoader> pluginsClassLoaders, Optional<ConfigurationProperties> parentConfigurationProperties, boolean disableXmlValidations) throws BeansException {
        this(muleContext, artifactConfigResources, artifactDeclaration, optionalObjectsController, parentConfigurationProperties, artifactProperties, artifactType, pluginsClassLoaders, disableXmlValidations);
    }

    public MuleArtifactContext(MuleContext muleContext, ConfigResource[] artifactConfigResources, ArtifactDeclaration artifactDeclaration, OptionalObjectsController optionalObjectsController, Optional<ConfigurationProperties> parentConfigurationProperties, Map<String, String> artifactProperties, ArtifactType artifactType, List<ClassLoader> pluginsClassLoaders, boolean disableXmlValidations) {
        Preconditions.checkArgument(optionalObjectsController != null, "optionalObjectsController cannot be null");
        this.muleContext = (MuleContextWithRegistries)muleContext;
        this.artifactConfigResources = artifactConfigResources;
        this.optionalObjectsController = optionalObjectsController;
        this.artifactProperties = artifactProperties;
        this.artifactType = artifactType;
        this.artifactDeclaration = artifactDeclaration;
        this.parentConfigurationProperties = parentConfigurationProperties;
        this.xmlConfigurationDocumentLoader = disableXmlValidations ? XmlConfigurationDocumentLoader.noValidationDocumentLoader() : XmlConfigurationDocumentLoader.schemaValidatingDocumentLoader();
        this.serviceDiscoverer = new DefaultRegistry(muleContext);
        ComponentBuildingDefinitionUtils.registerComponentBuildingDefinitions(this.serviceRegistry, MuleArtifactContext.class.getClassLoader(), this.componentBuildingDefinitionRegistry, MuleArtifactContext.getExtensionModels(muleContext.getExtensionManager()), componentBuildingDefinitionProvider -> componentBuildingDefinitionProvider.getComponentBuildingDefinitions());
        for (ClassLoader pluginArtifactClassLoader : pluginsClassLoaders) {
            ComponentBuildingDefinitionUtils.registerComponentBuildingDefinitions(this.serviceRegistry, pluginArtifactClassLoader, this.componentBuildingDefinitionRegistry, MuleArtifactContext.getExtensionModels(muleContext.getExtensionManager()), componentBuildingDefinitionProvider -> componentBuildingDefinitionProvider.getComponentBuildingDefinitions());
        }
        this.xmlApplicationParser = this.createApplicationParser(pluginsClassLoaders);
        this.beanDefinitionFactory = new BeanDefinitionFactory(this.componentBuildingDefinitionRegistry, muleContext.getErrorTypeRepository());
        this.createApplicationModel();
        this.validateAllConfigElementHaveParsers();
        this.dependencyResolver = new ConfigurationDependencyResolver(this.applicationModel, this.componentBuildingDefinitionRegistry);
    }

    private static Optional<Set<ExtensionModel>> getExtensionModels(ExtensionManager extensionManager) {
        return Optional.ofNullable(extensionManager == null ? null : extensionManager.getExtensions());
    }

    private XmlApplicationParser createApplicationParser(List<ClassLoader> pluginsClassLoaders) {
        ExtensionManager extensionManager = this.muleContext.getExtensionManager();
        ServiceRegistry customRegistry = extensionManager != null ? new XmlApplicationServiceRegistry(this.serviceRegistry, DslResolvingContext.getDefault(extensionManager.getExtensions())) : this.serviceRegistry;
        return new XmlApplicationParser(customRegistry, pluginsClassLoaders);
    }

    private void validateAllConfigElementHaveParsers() {
        this.applicationModel.executeOnEveryComponentTree(componentModel -> {
            Optional<ComponentIdentifier> parentIdentifierOptional = Optional.ofNullable(componentModel.getParent()).flatMap(parentComponentModel -> Optional.ofNullable(parentComponentModel.getIdentifier()));
            if (!this.beanDefinitionFactory.hasDefinition(componentModel.getIdentifier(), parentIdentifierOptional)) {
                this.componentNotSupportedByNewParsers.add(componentModel.getIdentifier());
                throw new RuntimeException(String.format("Invalid config '%s'", componentModel.getIdentifier()));
            }
        });
    }

    private void createApplicationModel() {
        try {
            ArtifactConfig artifactConfig = this.resolveArtifactConfig();
            Set<ExtensionModel> extensions = this.muleContext.getExtensionManager() != null ? this.muleContext.getExtensionManager().getExtensions() : Collections.emptySet();
            ClassLoaderResourceProvider externalResourceProvider = new ClassLoaderResourceProvider(this.muleContext.getExecutionClassLoader());
            this.applicationModel = new ApplicationModel(artifactConfig, this.artifactDeclaration, extensions, this.artifactProperties, this.parentConfigurationProperties, Optional.of(this.componentBuildingDefinitionRegistry), true, externalResourceProvider);
        }
        catch (MuleRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(e);
        }
    }

    private ArtifactConfig resolveArtifactConfig() throws IOException {
        ArtifactConfig.Builder applicationConfigBuilder = new ArtifactConfig.Builder();
        applicationConfigBuilder.setArtifactProperties(this.artifactProperties);
        ArrayList<Pair<String, InputStream>> initialConfigFiles = new ArrayList<Pair<String, InputStream>>();
        for (ConfigResource artifactConfigResource : this.artifactConfigResources) {
            initialConfigFiles.add(new Pair<String, InputStream>(artifactConfigResource.getResourceName(), artifactConfigResource.getInputStream()));
        }
        ArrayList<ConfigFile> configFiles = new ArrayList<ConfigFile>();
        this.recursivelyResolveConfigFiles(initialConfigFiles, configFiles).forEach(applicationConfigBuilder::addConfigFile);
        applicationConfigBuilder.setApplicationName(this.muleContext.getConfiguration().getId());
        return applicationConfigBuilder.build();
    }

    private List<ConfigFile> recursivelyResolveConfigFiles(List<Pair<String, InputStream>> configFilesToResolve, List<ConfigFile> alreadyResolvedConfigFiles) {
        DefaultConfigurationPropertiesResolver propertyResolver = new DefaultConfigurationPropertiesResolver(Optional.empty(), new SystemPropertiesConfigurationProvider());
        ImmutableList.Builder resolvedConfigFilesBuilder = ImmutableList.builder().addAll(alreadyResolvedConfigFiles);
        configFilesToResolve.stream().filter(fileNameInputStreamPair -> !alreadyResolvedConfigFiles.stream().anyMatch(configFile -> configFile.getFilename().equals(fileNameInputStreamPair.getFirst()))).forEach(fileNameInputStreamPair -> {
            Document document = this.xmlConfigurationDocumentLoader.loadDocument(this.muleContext.getExtensionManager() == null ? Collections.emptySet() : this.muleContext.getExtensionManager().getExtensions(), (String)fileNameInputStreamPair.getFirst(), (InputStream)fileNameInputStreamPair.getSecond());
            ConfigLine mainConfigLine = this.xmlApplicationParser.parse(document.getDocumentElement()).get();
            ConfigFile configFile = new ConfigFile((String)fileNameInputStreamPair.getFirst(), Arrays.asList(mainConfigLine));
            resolvedConfigFilesBuilder.add((Object)configFile);
            try {
                ((InputStream)fileNameInputStreamPair.getSecond()).close();
            }
            catch (IOException e) {
                throw new MuleRuntimeException(e);
            }
        });
        ImmutableSet.Builder importedFiles = ImmutableSet.builder();
        for (ConfigFile configFile : resolvedConfigFilesBuilder.build()) {
            List<ConfigLine> rootConfigLines = configFile.getConfigLines();
            ConfigLine muleRootElementConfigLine = rootConfigLines.get(0);
            importedFiles.addAll((Iterable)muleRootElementConfigLine.getChildren().stream().filter(configLine -> configLine.getNamespace().equals("mule") && configLine.getIdentifier().equals("import")).map(configLine -> {
                SimpleConfigAttribute fileConfigAttribute = configLine.getConfigAttributes().get("file");
                if (fileConfigAttribute == null) {
                    throw new RuntimeConfigurationException(I18nMessageFactory.createStaticMessage(String.format("<import> does not have a file attribute defined. At file '%s', at line %s", configFile.getFilename(), configLine.getLineNumber())));
                }
                return fileConfigAttribute.getValue();
            }).map(value -> (String)propertyResolver.resolveValue((String)value)).filter(fileName -> !alreadyResolvedConfigFiles.stream().anyMatch(solvedConfigFile -> solvedConfigFile.getFilename().equals(fileName))).collect(Collectors.toList()));
        }
        ImmutableSet importedConfigurationFiles = importedFiles.build();
        if (importedConfigurationFiles.isEmpty()) {
            return resolvedConfigFilesBuilder.build();
        }
        List<Pair<String, InputStream>> newConfigFilesToResolved = importedConfigurationFiles.stream().map(importedFileName -> {
            InputStream resourceAsStream = this.muleContext.getExecutionClassLoader().getResourceAsStream((String)importedFileName);
            if (resourceAsStream == null) {
                throw new RuntimeConfigurationException(I18nMessageFactory.createStaticMessage(String.format("Could not find imported resource '%s'", importedFileName)));
            }
            return new Pair<String, InputStream>((String)importedFileName, resourceAsStream);
        }).collect(Collectors.toList());
        return this.recursivelyResolveConfigFiles(newConfigFilesToResolved, (List<ConfigFile>)resolvedConfigFilesBuilder.build());
    }

    @Override
    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        this.registerEditors(beanFactory);
        this.registerAnnotationConfigProcessors((BeanDefinitionRegistry)((Object)beanFactory), beanFactory);
        this.addBeanPostProcessors(beanFactory, new MuleContextPostProcessor(this.muleContext), new PostRegistrationActionsPostProcessor((MuleRegistryHelper)this.muleContext.getRegistry(), beanFactory), new DiscardedOptionalBeanPostProcessor(this.optionalObjectsController, (DefaultListableBeanFactory)beanFactory), new LifecycleStatePostProcessor(this.muleContext.getLifecycleManager().getState()), new ComponentLocatorCreatePostProcessor(this.componentLocator));
        beanFactory.registerSingleton("_muleContext", this.muleContext);
        this.prepareObjectProviders();
    }

    protected void prepareObjectProviders() {
        MuleArtifactObjectProvider muleArtifactObjectProvider = new MuleArtifactObjectProvider(this);
        ImmutableObjectProviderConfiguration providerConfiguration = new ImmutableObjectProviderConfiguration(this.applicationModel.getConfigurationProperties(), muleArtifactObjectProvider);
        for (ConfigurableObjectProvider objectProvider : this.objectProviders) {
            objectProvider.configure(providerConfiguration);
        }
    }

    protected void registerObjectFromObjectProviders(ConfigurableListableBeanFactory beanFactory) {
        ((ObjectProviderAwareBeanFactory)beanFactory).setObjectProviders(this.objectProviders);
    }

    private List<Pair<ComponentModel, Optional<String>>> lookObjectProvidersComponentModels(ApplicationModel applicationModel) {
        ArrayList<Pair<ComponentModel, Optional<String>>> objectProviders = new ArrayList<Pair<ComponentModel, Optional<String>>>();
        applicationModel.executeOnEveryRootElement(componentModel -> {
            if (componentModel.isEnabled() && componentModel.getType() != null && ConfigurableObjectProvider.class.isAssignableFrom(componentModel.getType())) {
                objectProviders.add(new Pair<ComponentModel, Optional<String>>((ComponentModel)componentModel, Optional.ofNullable(componentModel.getNameAttribute())));
            }
        });
        return objectProviders;
    }

    private void registerEditors(ConfigurableListableBeanFactory beanFactory) {
        MulePropertyEditorRegistrar registrar = new MulePropertyEditorRegistrar();
        registrar.setMuleContext(this.muleContext);
        beanFactory.addPropertyEditorRegistrar(registrar);
    }

    protected void addBeanPostProcessors(ConfigurableListableBeanFactory beanFactory, BeanPostProcessor ... processors) {
        for (BeanPostProcessor processor : processors) {
            beanFactory.addBeanPostProcessor(processor);
        }
    }

    @Override
    public void close() {
        if (this.isRunning()) {
            super.close();
        }
        this.beanDefinitionFactory.destroy();
    }

    public static Resource[] convert(ConfigResource[] resources) {
        Resource[] configResources = new Resource[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            ConfigResource resource = resources[i];
            if (resource.getUrl() != null) {
                configResources[i] = new UrlResource(resource.getUrl());
                continue;
            }
            try {
                configResources[i] = new ByteArrayResource(IOUtils.toByteArray(resource.getInputStream()), resource.getResourceName());
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return configResources;
    }

    @Override
    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        this.createApplicationComponents(beanFactory, this.applicationModel, true);
    }

    @Override
    public void destroy() {
        try {
            super.destroy();
        }
        catch (Exception e) {
            for (ObjectProvider objectProvider : this.objectProviders) {
                LifecycleUtils.disposeIfNeeded(objectProvider, LOGGER);
            }
            throw new MuleRuntimeException(e);
        }
    }

    protected List<String> createApplicationComponents(DefaultListableBeanFactory beanFactory, ApplicationModel applicationModel, boolean mustBeRoot) {
        List<Pair<ComponentModel, Optional<String>>> objectProvidersByName = this.lookObjectProvidersComponentModels(applicationModel);
        ArrayList<String> createdComponentModels = new ArrayList<String>();
        applicationModel.executeOnEveryMuleComponentTree(cm -> {
            SpringComponentModel componentModel = (SpringComponentModel)cm;
            if (!mustBeRoot || componentModel.isRoot()) {
                SpringComponentModel parentComponentModel;
                if (componentModel.getIdentifier().equals(CoreDslConstants.MULE_IDENTIFIER)) {
                    return;
                }
                SpringComponentModel springComponentModel = parentComponentModel = componentModel.getParent() != null ? (SpringComponentModel)componentModel.getParent() : (SpringComponentModel)applicationModel.getRootComponentModel();
                if (componentModel.isEnabled()) {
                    if (componentModel.getNameAttribute() != null && componentModel.isRoot()) {
                        createdComponentModels.add(componentModel.getNameAttribute());
                    }
                    this.beanDefinitionFactory.resolveComponentRecursively(parentComponentModel, componentModel, beanFactory, (resolvedComponentModel, registry) -> {
                        SpringComponentModel resolvedSpringComponentModel = (SpringComponentModel)resolvedComponentModel;
                        if (resolvedComponentModel.isRoot()) {
                            String nameAttribute = resolvedComponentModel.getNameAttribute();
                            if (resolvedComponentModel.getIdentifier().equals(CoreDslConstants.CONFIGURATION_IDENTIFIER)) {
                                nameAttribute = "_muleConfiguration";
                            } else if (nameAttribute == null) {
                                nameAttribute = AutoIdUtils.uniqueValue(resolvedSpringComponentModel.getBeanDefinition().getBeanClassName());
                            }
                            registry.registerBeanDefinition(nameAttribute, resolvedSpringComponentModel.getBeanDefinition());
                            MuleArtifactContext.postProcessBeanDefinition(componentModel, registry, nameAttribute);
                        }
                    }, null, this.componentLocator);
                } else {
                    this.beanDefinitionFactory.resolveComponentRecursively(parentComponentModel, componentModel, beanFactory, null, null, this.componentLocator);
                }
                this.componentLocator.addComponentLocation(cm.getComponentLocation());
            }
        });
        this.objectProviders.addAll(objectProvidersByName.stream().map(pair -> (ConfigurableObjectProvider)((ComponentModel)pair.getFirst()).getObjectInstance()).collect(Collectors.toList()));
        this.registerObjectFromObjectProviders(beanFactory);
        Set<String> alwaysEnabledComponents = this.dependencyResolver.resolveAlwaysEnabledComponents();
        Set objectProviderNames = objectProvidersByName.stream().map(Pair::getSecond).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        createdComponentModels.sort(Comparator.comparing(beanName -> {
            if (objectProviderNames.contains(beanName)) {
                return 1;
            }
            if (alwaysEnabledComponents.contains(beanName)) {
                return 2;
            }
            return 3;
        }));
        return createdComponentModels;
    }

    public ConfigurationDependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    @Override
    protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
        super.customizeBeanFactory(beanFactory);
        new SpringMuleContextServiceConfigurator(this.muleContext, this.applicationModel.getConfigurationProperties(), this.artifactType, this.optionalObjectsController, beanFactory, this.componentLocator, this.serviceDiscoverer).createArtifactServices();
    }

    @Override
    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        Optional<ComponentModel> configurationOptional = this.applicationModel.findComponentDefinitionModel(CoreDslConstants.CONFIGURATION_IDENTIFIER);
        if (configurationOptional.isPresent()) {
            return;
        }
        BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)((Object)beanFactory);
        beanDefinitionRegistry.registerBeanDefinition("_muleConfiguration", BeanDefinitionBuilder.genericBeanDefinition(MuleConfigurationConfigurator.class).getBeanDefinition());
    }

    private void registerAnnotationConfigProcessors(BeanDefinitionRegistry registry, ConfigurableListableBeanFactory beanFactory) {
        this.registerAnnotationConfigProcessor(registry, "org.springframework.AAA.context.annotation.internalConfigurationAnnotationProcessor", ConfigurationClassPostProcessor.class, null);
        this.registerAnnotationConfigProcessor(registry, "org.springframework.AAA.context.annotation.internalRequiredAnnotationProcessor", RequiredAnnotationBeanPostProcessor.class, null);
        this.registerInjectorProcessor(beanFactory);
    }

    protected void registerInjectorProcessor(ConfigurableListableBeanFactory beanFactory) {
        MuleInjectorProcessor muleInjectorProcessor = null;
        if (this.artifactType.equals((Object)ArtifactType.APP)) {
            muleInjectorProcessor = new MuleInjectorProcessor();
        } else if (this.artifactType.equals((Object)ArtifactType.DOMAIN)) {
            muleInjectorProcessor = new ContextExclusiveInjectorProcessor(this);
        }
        if (muleInjectorProcessor != null) {
            muleInjectorProcessor.setBeanFactory(beanFactory);
            beanFactory.addBeanPostProcessor(muleInjectorProcessor);
        }
    }

    private void registerAnnotationConfigProcessor(BeanDefinitionRegistry registry, String key, Class<?> type, Object source) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(type);
        beanDefinition.setSource(source);
        this.registerPostProcessor(registry, beanDefinition, key);
    }

    protected void registerPostProcessor(BeanDefinitionRegistry registry, RootBeanDefinition definition, String beanName) {
        definition.setRole(2);
        registry.registerBeanDefinition(beanName, definition);
    }

    @Override
    protected DefaultListableBeanFactory createBeanFactory() {
        ObjectProviderAwareBeanFactory beanFactory = new ObjectProviderAwareBeanFactory(this.getInternalParentBeanFactory());
        beanFactory.setAutowireCandidateResolver(new ContextAnnotationAutowireCandidateResolver());
        beanFactory.setInstantiationStrategy(new LaxInstantiationStrategyWrapper(new CglibSubclassingInstantiationStrategy(), this.optionalObjectsController));
        return beanFactory;
    }

    @Override
    public boolean isRunning() {
        try {
            return super.isRunning();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    protected static void postProcessBeanDefinition(SpringComponentModel resolvedComponent, BeanDefinitionRegistry registry, String beanName) {
        if (Converter.class.isAssignableFrom(resolvedComponent.getType())) {
            GenericBeanDefinition converterBeanDefinitionCopy = new GenericBeanDefinition(resolvedComponent.getBeanDefinition());
            converterBeanDefinitionCopy.setScope("singleton");
            registry.registerBeanDefinition(beanName + "-converter", converterBeanDefinitionCopy);
        }
    }

    public MuleContextWithRegistries getMuleContext() {
        return this.muleContext;
    }

    public OptionalObjectsController getOptionalObjectsController() {
        return this.optionalObjectsController;
    }

    public synchronized void getPrototypeBeanWithRootContainer(String name, String rootContainerName) {
        BeanDefinition beanDefinition = this.getBeanFactory().getBeanDefinition(name);
        Preconditions.checkState(beanDefinition.isPrototype(), String.format("Bean with name %s is not a prototype", name));
        this.updateBeanDefinitionRootContainerName(rootContainerName, beanDefinition);
    }

    private void updateBeanDefinitionRootContainerName(String rootContainerName, BeanDefinition beanDefinition) {
        ComponentModelHelper.updateAnnotationValue(AbstractComponent.ROOT_CONTAINER_NAME_KEY, rootContainerName, beanDefinition);
        for (PropertyValue propertyValue : beanDefinition.getPropertyValues().getPropertyValueList()) {
            Object value = propertyValue.getValue();
            this.processBeanValue(rootContainerName, value);
        }
        for (ConstructorArgumentValues.ValueHolder valueHolder : beanDefinition.getConstructorArgumentValues().getGenericArgumentValues()) {
            this.processBeanValue(rootContainerName, valueHolder.getValue());
        }
    }

    private void processBeanValue(String rootContainerName, Object value) {
        if (value instanceof BeanDefinition) {
            this.updateBeanDefinitionRootContainerName(rootContainerName, (BeanDefinition)value);
        } else if (value instanceof ManagedList) {
            ManagedList managedList = (ManagedList)value;
            for (int i = 0; i < managedList.size(); ++i) {
                Object itemValue = managedList.get(i);
                if (!(itemValue instanceof BeanDefinition)) continue;
                this.updateBeanDefinitionRootContainerName(rootContainerName, (BeanDefinition)itemValue);
            }
        } else if (value instanceof ManagedMap) {
            ManagedMap managedMap = (ManagedMap)value;
            managedMap.forEach((key, mapValue) -> this.processBeanValue(rootContainerName, mapValue));
        }
    }

    public Registry getRegistry() {
        return (Registry)this.getMuleContext().getRegistry().get("_muleRegistry");
    }
}

