/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.AAA.util.Assert;
import org.springframework.AAA.util.ClassUtils;
import org.springframework.AAA.util.CollectionUtils;
import org.springframework.AAA.util.ResourceUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class MuleCustomEntityResolver
implements EntityResolver {
    public static final String CUSTOM_SCHEMA_MAPPINGS_LOCATION = "META-INF/mule.schemas";
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleCustomEntityResolver.class);
    private ClassLoader classLoader;
    private Map<String, String> schemaMappings;

    MuleCustomEntityResolver(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.schemaMappings = this.getSchemaMappings();
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        String resourceLocation;
        if (systemId != null && (resourceLocation = this.schemaMappings.get(systemId)) != null) {
            InputStream is = this.classLoader.getResourceAsStream(resourceLocation);
            if (is == null) {
                LOGGER.debug("Couldn't find XML schema [" + systemId + "]: " + resourceLocation);
                return null;
            }
            InputSource source = new InputSource(is);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found XML schema [" + systemId + "] in classpath: " + resourceLocation);
            }
            return source;
        }
        return null;
    }

    private Map<String, String> getSchemaMappings() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loading schema mappings from [META-INF/mule.schemas]");
        }
        try {
            Properties mappings = MuleCustomEntityResolver.loadAllProperties(CUSTOM_SCHEMA_MAPPINGS_LOCATION, this.classLoader);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Loaded schema mappings: " + mappings);
            }
            HashMap<String, String> schemaMappings = new HashMap<String, String>(mappings.size());
            CollectionUtils.mergePropertiesIntoMap(mappings, schemaMappings);
            return schemaMappings;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to load schema mappings from location [META-INF/mule.schemas]", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadAllProperties(String resourceName, ClassLoader classLoader) throws IOException {
        Assert.notNull(resourceName, "Resource name must not be null");
        ClassLoader classLoaderToUse = classLoader;
        if (classLoaderToUse == null) {
            classLoaderToUse = ClassUtils.getDefaultClassLoader();
        }
        Enumeration<URL> urls = classLoaderToUse != null ? classLoaderToUse.getResources(resourceName) : ClassLoader.getSystemResources(resourceName);
        Properties props = new Properties();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            URLConnection con = url.openConnection();
            ResourceUtils.useCachesIfNecessary(con);
            try (InputStream is = con.getInputStream();){
                if (resourceName != null && resourceName.endsWith(".xml")) {
                    props.loadFromXML(is);
                    continue;
                }
                props.load(is);
            }
        }
        return props;
    }
}

