/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.declaration;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComposableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.construct.HasConstructModels;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.RouteElementDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ArtifactDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ComponentElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConstructElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.HasNestedComponentDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterGroupElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterListValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterObjectValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterSimpleValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterizedBuilder;
import org.mule.runtime.app.declaration.api.fluent.ParameterizedElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.RouteElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.TopLevelParameterDeclarer;
import org.mule.runtime.config.api.XmlConfigurationDocumentLoader;
import org.mule.runtime.config.api.dsl.processor.ConfigLine;
import org.mule.runtime.config.api.dsl.processor.SimpleConfigAttribute;
import org.mule.runtime.config.api.dsl.processor.xml.XmlApplicationParser;
import org.mule.runtime.config.api.dsl.processor.xml.XmlApplicationServiceRegistry;
import org.mule.runtime.config.internal.dsl.model.XmlArtifactDeclarationLoader;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.deployment.model.internal.application.MuleApplicationClassLoader;
import org.mule.runtime.extension.api.declaration.type.annotation.ExtensibleTypeAnnotation;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.w3c.dom.Document;

public class DefaultXmlArtifactDeclarationLoader
implements XmlArtifactDeclarationLoader {
    public static final String TRANSFORM_IDENTIFIER = "transform";
    public static final String TRANSFORM_SCRIPT = "script";
    public static final String TRANSFORM_RESOURCE = "resource";
    public static final String TRANSFORM_VARIABLE_NAME = "variableName";
    private final DslResolvingContext context;
    private final Map<ExtensionModel, DslSyntaxResolver> resolvers;
    private final Map<String, ExtensionModel> extensionsByNamespace = new HashMap<String, ExtensionModel>();

    public DefaultXmlArtifactDeclarationLoader(DslResolvingContext context) {
        this.context = context;
        this.resolvers = context.getExtensions().stream().collect(Collectors.toMap(e -> e, e -> DslSyntaxResolver.getDefault(e, context)));
    }

    @Override
    public ArtifactDeclaration load(InputStream configResource) {
        return this.load("app.xml", configResource);
    }

    @Override
    public ArtifactDeclaration load(String name, InputStream configResource) {
        this.context.getExtensions().forEach(e -> this.extensionsByNamespace.put(e.getXmlDslModel().getPrefix(), (ExtensionModel)e));
        ConfigLine configLine = this.loadArtifactConfig(name, configResource);
        return this.declareArtifact(configLine);
    }

    private ConfigLine loadArtifactConfig(String name, InputStream resource) {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"The given application was not found as resource");
        Document document = XmlConfigurationDocumentLoader.noValidationDocumentLoader().loadDocument(this.context.getExtensions(), name, resource);
        return new XmlApplicationParser(new XmlApplicationServiceRegistry(new SpiServiceRegistry(), this.context), MuleApplicationClassLoader.resolveContextArtifactPluginClassLoaders()).parse(document.getDocumentElement()).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not load load a Configuration from the given resource")));
    }

    private ArtifactDeclaration declareArtifact(ConfigLine configLine) {
        ArtifactDeclarer artifactDeclarer = ElementDeclarer.newArtifact();
        configLine.getConfigAttributes().values().forEach(a -> {
            ArtifactDeclarer cfr_ignored_0 = (ArtifactDeclarer)artifactDeclarer.withCustomParameter(a.getName(), a.getValue());
        });
        configLine.getChildren().forEach(line -> this.declareElement((ConfigLine)line, artifactDeclarer));
        return (ArtifactDeclaration)artifactDeclarer.getDeclaration();
    }

    private void declareElement(final ConfigLine configLine, final ArtifactDeclarer artifactDeclarer) {
        final ExtensionModel ownerExtension = this.getExtensionModel(configLine);
        final ElementDeclarer extensionElementsDeclarer = ElementDeclarer.forExtension(ownerExtension.getName());
        final DslSyntaxResolver dsl = this.resolvers.get(ownerExtension);
        final Reference<Boolean> alreadyDeclared = new Reference<Boolean>(false);
        new ExtensionWalker(){

            @Override
            protected void onConstruct(HasConstructModels owner, ConstructModel model) {
                DefaultXmlArtifactDeclarationLoader.this.declareComponentModel(dsl, configLine, model, extensionElementsDeclarer::newConstruct).ifPresent(declarer -> {
                    DefaultXmlArtifactDeclarationLoader.this.getDeclaredName(configLine).ifPresent(((ConstructElementDeclarer)declarer)::withRefName);
                    artifactDeclarer.withGlobalElement((GlobalElementDeclaration)declarer.getDeclaration());
                    alreadyDeclared.set(true);
                    this.stop();
                });
            }

            @Override
            protected void onConfiguration(ConfigurationModel model) {
                DslElementSyntax elementDsl = dsl.resolve(model);
                if (elementDsl.getElementName().equals(configLine.getIdentifier())) {
                    ConfigurationElementDeclarer configurationDeclarer = extensionElementsDeclarer.newConfiguration(model.getName());
                    DefaultXmlArtifactDeclarationLoader.this.getDeclaredName(configLine).ifPresent(configurationDeclarer::withRefName);
                    Map<String, SimpleConfigAttribute> attributes = configLine.getConfigAttributes().values().stream().filter(a -> !a.getName().equals("name")).collect(Collectors.toMap(SimpleConfigAttribute::getName, a -> a));
                    List configComplexParameters = configLine.getChildren().stream().filter(config -> this.declareAsConnectionProvider(ownerExtension, model, configurationDeclarer, (ConfigLine)config)).collect(Collectors.toList());
                    DefaultXmlArtifactDeclarationLoader.this.declareParameterizedComponent(model, elementDsl, configurationDeclarer, attributes, configComplexParameters);
                    artifactDeclarer.withGlobalElement((GlobalElementDeclaration)configurationDeclarer.getDeclaration());
                    alreadyDeclared.set(true);
                    this.stop();
                }
            }

            private boolean declareAsConnectionProvider(ExtensionModel ownerExtension2, ConfigurationModel model, ConfigurationElementDeclarer configurationDeclarer, ConfigLine config) {
                Optional<ConnectionProviderModel> connectionProvider = model.getConnectionProviders().stream().filter(cp -> dsl.resolve((NamedObject)cp).getElementName().equals(config.getIdentifier())).findFirst();
                if (!connectionProvider.isPresent()) {
                    connectionProvider = ownerExtension2.getConnectionProviders().stream().filter(cp -> dsl.resolve((NamedObject)cp).getElementName().equals(config.getIdentifier())).findFirst();
                }
                if (!connectionProvider.isPresent()) {
                    return true;
                }
                ConnectionProviderModel providerModel = connectionProvider.get();
                ConnectionElementDeclarer connectionDeclarer = extensionElementsDeclarer.newConnection(providerModel.getName());
                DefaultXmlArtifactDeclarationLoader.this.declareParameterizedComponent(providerModel, dsl.resolve(providerModel), connectionDeclarer, config.getConfigAttributes(), config.getChildren());
                configurationDeclarer.withConnection((ConnectionElementDeclaration)connectionDeclarer.getDeclaration());
                return false;
            }
        }.walk(ownerExtension);
        if (!alreadyDeclared.get().booleanValue()) {
            ownerExtension.getTypes().stream().filter(type -> dsl.resolve((MetadataType)type).map(typeDsl -> typeDsl.getElementName().equals(configLine.getIdentifier())).orElse(false)).findFirst().ifPresent(type -> {
                TopLevelParameterDeclarer topLevelParameter = extensionElementsDeclarer.newGlobalParameter(configLine.getIdentifier());
                this.getDeclaredName(configLine).ifPresent(topLevelParameter::withRefName);
                type.accept(this.getParameterDeclarerVisitor(configLine, dsl.resolve((MetadataType)type).get(), value -> topLevelParameter.withValue((ParameterObjectValue)value)));
                artifactDeclarer.withGlobalElement((GlobalElementDeclaration)topLevelParameter.getDeclaration());
            });
        }
    }

    private Optional<String> getDeclaredName(ConfigLine configLine) {
        return Optional.ofNullable(configLine.getConfigAttributes().get("name")).map(SimpleConfigAttribute::getValue);
    }

    private ExtensionModel getExtensionModel(ConfigLine line) {
        String namespace = this.getNamespace(line);
        ExtensionModel extensionModel = this.extensionsByNamespace.get(namespace);
        if (extensionModel == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Missing Extension model in the context for namespace [" + namespace + "]"));
        }
        return extensionModel;
    }

    private ExtensionWalker getComponentDeclaringWalker(final Consumer<ComponentElementDeclaration> declarationConsumer, final ConfigLine line, final ElementDeclarer extensionElementsDeclarer, final DslSyntaxResolver dsl) {
        return new ExtensionWalker(){

            @Override
            protected void onOperation(HasOperationModels owner, OperationModel model) {
                if (!model.getName().equals(DefaultXmlArtifactDeclarationLoader.TRANSFORM_IDENTIFIER)) {
                    DefaultXmlArtifactDeclarationLoader.this.declareComponentModel(dsl, line, model, extensionElementsDeclarer::newOperation).ifPresent(declarer -> {
                        declarationConsumer.accept((ComponentElementDeclaration)declarer.getDeclaration());
                        this.stop();
                    });
                } else {
                    this.declareTransform(model);
                }
            }

            @Override
            protected void onSource(HasSourceModels owner, SourceModel model) {
                DefaultXmlArtifactDeclarationLoader.this.declareComponentModel(dsl, line, model, extensionElementsDeclarer::newSource).ifPresent(declarer -> {
                    DslElementSyntax elementDsl = dsl.resolve(model);
                    model.getSuccessCallback().ifPresent(cb -> DefaultXmlArtifactDeclarationLoader.this.declareParameterizedComponent(cb, elementDsl, declarer, line.getConfigAttributes(), line.getChildren()));
                    model.getErrorCallback().ifPresent(cb -> DefaultXmlArtifactDeclarationLoader.this.declareParameterizedComponent(cb, elementDsl, declarer, line.getConfigAttributes(), line.getChildren()));
                    declarationConsumer.accept((ComponentElementDeclaration)declarer.getDeclaration());
                    this.stop();
                });
            }

            @Override
            protected void onConstruct(HasConstructModels owner, ConstructModel model) {
                DefaultXmlArtifactDeclarationLoader.this.declareComponentModel(dsl, line, model, extensionElementsDeclarer::newConstruct).ifPresent(declarer -> {
                    declarationConsumer.accept((ComponentElementDeclaration)declarer.getDeclaration());
                    this.stop();
                });
            }

            private void declareTransform(ComponentModel model) {
                DslElementSyntax elementDsl = dsl.resolve(model);
                if (model.getName().equals(DefaultXmlArtifactDeclarationLoader.TRANSFORM_IDENTIFIER) && elementDsl.getElementName().equals(line.getIdentifier())) {
                    OperationElementDeclarer transform = extensionElementsDeclarer.newOperation(DefaultXmlArtifactDeclarationLoader.TRANSFORM_IDENTIFIER);
                    line.getChildren().stream().filter(c -> c.getIdentifier().equals("message")).findFirst().ifPresent(messageConfig -> {
                        ParameterGroupElementDeclarer messageGroup = ElementDeclarer.newParameterGroup("Message");
                        messageConfig.getChildren().stream().filter(c -> c.getIdentifier().equals("set-payload")).findFirst().ifPresent(payloadConfig -> {
                            ParameterObjectValue.Builder payload = ElementDeclarer.newObjectValue();
                            DefaultXmlArtifactDeclarationLoader.this.populateTransformScriptParameter(payloadConfig, payload);
                            messageGroup.withParameter("setPayload", payload.build());
                        });
                        messageConfig.getChildren().stream().filter(c -> c.getIdentifier().equals("set-attributes")).findFirst().ifPresent(attributesConfig -> {
                            ParameterObjectValue.Builder attributes = ElementDeclarer.newObjectValue();
                            DefaultXmlArtifactDeclarationLoader.this.populateTransformScriptParameter(attributesConfig, attributes);
                            messageGroup.withParameter("setAttributes", attributes.build());
                        });
                        transform.withParameterGroup((ParameterGroupElementDeclaration)messageGroup.getDeclaration());
                    });
                    line.getChildren().stream().filter(c -> c.getIdentifier().equals("variables")).findFirst().ifPresent(variablesConfig -> {
                        ParameterGroupElementDeclarer variablesGroup = ElementDeclarer.newParameterGroup("Set Variables");
                        ParameterListValue.Builder variables = ElementDeclarer.newListValue();
                        variablesConfig.getChildren().forEach(variableConfig -> {
                            ParameterObjectValue.Builder variable = ElementDeclarer.newObjectValue();
                            variable.withParameter(DefaultXmlArtifactDeclarationLoader.TRANSFORM_VARIABLE_NAME, variableConfig.getConfigAttributes().get(DefaultXmlArtifactDeclarationLoader.TRANSFORM_VARIABLE_NAME).getValue());
                            DefaultXmlArtifactDeclarationLoader.this.populateTransformScriptParameter(variableConfig, variable);
                            variables.withValue(variable.build());
                        });
                        transform.withParameterGroup((ParameterGroupElementDeclaration)variablesGroup.withParameter("setVariables", variables.build()).getDeclaration());
                    });
                    line.getConfigAttributes().values().forEach(a -> transform.withCustomParameter(a.getName(), a.getValue()));
                    declarationConsumer.accept((ComponentElementDeclaration)transform.getDeclaration());
                    this.stop();
                }
            }
        };
    }

    private Optional<ComponentElementDeclarer> declareComponentModel(DslSyntaxResolver dsl, ConfigLine line, ComponentModel model, Function<String, ComponentElementDeclarer> declarerBuilder) {
        DslElementSyntax elementDsl = dsl.resolve(model);
        if (elementDsl.getElementName().equals(line.getIdentifier())) {
            ComponentElementDeclarer declarer = declarerBuilder.apply(model.getName());
            if (line.getConfigAttributes().get("config-ref") != null) {
                declarer.withConfig(line.getConfigAttributes().get("config-ref").getValue());
            }
            this.declareParameterizedComponent(model, elementDsl, declarer, line.getConfigAttributes(), line.getChildren());
            if (model instanceof ComposableModel) {
                this.declareComposableModel(model, elementDsl, dsl, line, declarer);
            }
            return Optional.of(declarer);
        }
        return Optional.empty();
    }

    private void populateTransformScriptParameter(ConfigLine config, ParameterObjectValue.Builder builder) {
        if (config.getConfigAttributes().containsKey(TRANSFORM_RESOURCE)) {
            builder.withParameter(TRANSFORM_RESOURCE, config.getConfigAttributes().get(TRANSFORM_RESOURCE).getValue());
        }
        if (!StringUtils.isBlank((CharSequence)config.getTextContent())) {
            builder.withParameter(TRANSFORM_SCRIPT, config.getTextContent());
        }
        config.getConfigAttributes().entrySet().stream().filter(e -> !((String)e.getKey()).equals(TRANSFORM_RESOURCE)).map(Map.Entry::getValue).forEach(a -> builder.withParameter(a.getName(), a.getValue()));
    }

    private boolean isCData(ConfigLine config) {
        return config.getCustomAttributes().get("IS_CDATA") != null;
    }

    private void declareComposableModel(ComposableModel model, DslElementSyntax elementDsl, DslSyntaxResolver dsl, ConfigLine containerConfig, HasNestedComponentDeclarer declarer) {
        containerConfig.getChildren().forEach(child -> {
            ExtensionModel extensionModel = this.getExtensionModel((ConfigLine)child);
            ElementDeclarer extensionElementsDeclarer = ElementDeclarer.forExtension(extensionModel.getName());
            Reference<Boolean> componentFound = new Reference<Boolean>(false);
            this.getComponentDeclaringWalker(declaration -> {
                declarer.withComponent((ComponentElementDeclaration)declaration);
                componentFound.set(true);
            }, (ConfigLine)child, extensionElementsDeclarer, dsl).walk(extensionModel);
            if (!componentFound.get().booleanValue()) {
                this.declareRoute(model, elementDsl, dsl, (ConfigLine)child, extensionElementsDeclarer).ifPresent(declarer::withComponent);
            }
        });
    }

    private Optional<RouteElementDeclaration> declareRoute(ComposableModel model, DslElementSyntax elementDsl, DslSyntaxResolver dsl, ConfigLine child, ElementDeclarer extensionElementsDeclarer) {
        return model.getNestedComponents().stream().filter(nestedModel -> elementDsl.getContainedElement(nestedModel.getName()).map(nestedDsl -> child.getIdentifier().equals(nestedDsl.getElementName())).orElse(false)).filter(nestedModel -> nestedModel instanceof NestedRouteModel).findFirst().map(nestedModel -> {
            RouteElementDeclarer routeDeclarer = extensionElementsDeclarer.newRoute(nestedModel.getName());
            DslElementSyntax routeDsl = elementDsl.getContainedElement(nestedModel.getName()).get();
            this.declareParameterizedComponent((ParameterizedModel)((Object)nestedModel), routeDsl, routeDeclarer, child.getConfigAttributes(), child.getChildren());
            this.declareComposableModel((ComposableModel)((Object)nestedModel), elementDsl, dsl, child, routeDeclarer);
            return (RouteElementDeclaration)routeDeclarer.getDeclaration();
        });
    }

    private void declareParameterizedComponent(ParameterizedModel model, DslElementSyntax elementDsl, ParameterizedElementDeclarer declarer, Map<String, SimpleConfigAttribute> configAttributes, List<ConfigLine> children) {
        this.copyExplicitAttributes(model, configAttributes, declarer);
        this.declareChildParameters(model, elementDsl, children, declarer);
    }

    private void declareChildParameters(ParameterizedModel model, DslElementSyntax modelDsl, List<ConfigLine> children, ParameterizedElementDeclarer declarer) {
        model.getParameterGroupModels().forEach(group -> {
            if (group.isShowInDsl()) {
                modelDsl.getChild(group.getName()).ifPresent(groupDsl -> children.stream().filter(c -> c.getIdentifier().equals(groupDsl.getElementName())).findFirst().ifPresent(groupConfig -> this.declareInlineGroup((ParameterGroupModel)group, (DslElementSyntax)groupDsl, (ConfigLine)groupConfig, declarer)));
            } else {
                ParameterGroupElementDeclarer groupDeclarer = ElementDeclarer.newParameterGroup(group.getName());
                group.getParameterModels().forEach(param -> modelDsl.getChild(param.getName()).ifPresent(paramDsl -> {
                    if (ExtensionModelUtils.isInfrastructure(param)) {
                        this.handleInfrastructure((ParameterModel)param, children, declarer);
                    } else {
                        children.stream().filter(c -> c.getIdentifier().equals(paramDsl.getElementName())).findFirst().ifPresent(paramConfig -> param.getType().accept(this.getParameterDeclarerVisitor((ConfigLine)paramConfig, (DslElementSyntax)paramDsl, value -> groupDeclarer.withParameter(param.getName(), (ParameterValue)value))));
                    }
                }));
                if (!((ParameterGroupElementDeclaration)groupDeclarer.getDeclaration()).getParameters().isEmpty()) {
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)groupDeclarer.getDeclaration());
                }
            }
        });
    }

    private void declareInlineGroup(ParameterGroupModel model, DslElementSyntax dsl, ConfigLine config, ParameterizedElementDeclarer groupContainer) {
        ParameterGroupElementDeclarer groupDeclarer = ElementDeclarer.newParameterGroup(model.getName());
        this.copyExplicitAttributes(config.getConfigAttributes(), groupDeclarer);
        this.declareComplexParameterValue(model, dsl, config.getChildren(), groupDeclarer);
        groupContainer.withParameterGroup((ParameterGroupElementDeclaration)groupDeclarer.getDeclaration());
    }

    private void declareComplexParameterValue(ParameterGroupModel group, DslElementSyntax groupDsl, List<ConfigLine> groupChilds, ParameterizedBuilder<String, ParameterValue, ?> groupBuilder) {
        groupChilds.forEach(child -> group.getParameterModels().stream().filter(param -> groupDsl.getChild(param.getName()).map(dsl -> dsl.getElementName().equals(child.getIdentifier())).orElse(false)).findFirst().ifPresent(param -> param.getType().accept(this.getParameterDeclarerVisitor((ConfigLine)child, groupDsl.getChild(param.getName()).get(), value -> groupBuilder.withParameter(param.getName(), (ParameterValue)value)))));
    }

    private MetadataTypeVisitor getParameterDeclarerVisitor(final ConfigLine config, final DslElementSyntax paramDsl, final Consumer<ParameterValue> valueConsumer) {
        return new MetadataTypeVisitor(){

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                if (config.getTextContent() != null) {
                    valueConsumer.accept(DefaultXmlArtifactDeclarationLoader.this.isCData(config) ? ParameterSimpleValue.cdata(config.getTextContent()) : ParameterSimpleValue.plain(config.getTextContent()));
                }
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                ParameterListValue.Builder listBuilder = ElementDeclarer.newListValue();
                config.getChildren().forEach(item -> arrayType.getType().accept(DefaultXmlArtifactDeclarationLoader.this.getParameterDeclarerVisitor(item, paramDsl.getGeneric(arrayType.getType()).get(), listBuilder::withValue)));
                valueConsumer.accept(listBuilder.build());
            }

            @Override
            public void visitObject(ObjectType objectType) {
                if (config.getConfigAttributes().isEmpty() && config.getChildren().isEmpty()) {
                    this.defaultVisit(objectType);
                    return;
                }
                ParameterObjectValue.Builder objectValue = ElementDeclarer.newObjectValue();
                if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                    DefaultXmlArtifactDeclarationLoader.this.createMapValue(objectValue, config);
                } else if (paramDsl.isWrapped()) {
                    if (config.getChildren().size() == 1) {
                        DefaultXmlArtifactDeclarationLoader.this.createWrappedObject(objectType, objectValue, config);
                    }
                } else {
                    DefaultXmlArtifactDeclarationLoader.this.createObjectValueFromType(objectType, objectValue, config, paramDsl);
                }
                valueConsumer.accept(objectValue.build());
            }
        };
    }

    private void createMapValue(ParameterObjectValue.Builder objectValue, ConfigLine config) {
        config.getChildren().stream().map(ConfigLine::getConfigAttributes).forEach(entry -> {
            SimpleConfigAttribute entryKey = (SimpleConfigAttribute)entry.get("key");
            SimpleConfigAttribute entryValue = (SimpleConfigAttribute)entry.get("value");
            if (entryKey != null && entryValue != null) {
                objectValue.withParameter(entryKey.getValue(), entryValue.getValue());
            }
        });
    }

    private void createWrappedObject(ObjectType objectType, ParameterObjectValue.Builder objectValue, ConfigLine config) {
        ConfigLine wrappedConfig = config.getChildren().get(0);
        DslSyntaxResolver wrappedElementResolver = this.resolvers.get(this.extensionsByNamespace.get(wrappedConfig.getNamespace()));
        Set<ObjectType> subTypes = this.context.getTypeCatalog().getSubTypes(objectType);
        if (!subTypes.isEmpty()) {
            subTypes.stream().filter(subType -> wrappedElementResolver.resolve((MetadataType)subType).map(dsl -> dsl.getElementName().equals(wrappedConfig.getIdentifier())).orElse(false)).findFirst().ifPresent(subType -> this.createObjectValueFromType((ObjectType)subType, objectValue, wrappedConfig, wrappedElementResolver.resolve((MetadataType)subType).get()));
        } else if (objectType.getAnnotation(ExtensibleTypeAnnotation.class).isPresent()) {
            this.createObjectValueFromType(objectType, objectValue, wrappedConfig, wrappedElementResolver.resolve(objectType).get());
        }
    }

    private void createObjectValueFromType(ObjectType objectType, ParameterObjectValue.Builder objectValue, ConfigLine config, DslElementSyntax paramDsl) {
        ExtensionMetadataTypeUtils.getId(objectType).ifPresent(objectValue::ofType);
        this.copyExplicitAttributes(config.getConfigAttributes(), objectValue);
        config.getChildren().forEach(fieldConfig -> objectType.getFields().stream().filter(fieldType -> paramDsl.getContainedElement(MetadataTypeUtils.getLocalPart(fieldType)).map(fieldDsl -> fieldDsl.getElementName().equals(fieldConfig.getIdentifier())).orElse(false)).findFirst().ifPresent(fieldType -> fieldType.getValue().accept(this.getParameterDeclarerVisitor((ConfigLine)fieldConfig, paramDsl.getContainedElement(MetadataTypeUtils.getLocalPart(fieldType)).get(), fieldValue -> objectValue.withParameter(MetadataTypeUtils.getLocalPart(fieldType), (ParameterValue)fieldValue)))));
    }

    private void handleInfrastructure(ParameterModel paramModel, List<ConfigLine> declaredConfigs, ParameterizedElementDeclarer declarer) {
        switch (paramModel.getName()) {
            case "reconnection": {
                this.findAnyMatchingChildById(declaredConfigs, "reconnection").ifPresent(config -> {
                    ParameterObjectValue.Builder reconnection = ElementDeclarer.newObjectValue().ofType(config.getIdentifier());
                    this.copyExplicitAttributes(config.getConfigAttributes(), reconnection);
                    config.getChildren().forEach(child -> {
                        String paramName = child.getIdentifier().equals("reconnect") || child.getIdentifier().equals("reconnect-forever") ? "reconnectionStrategy" : child.getIdentifier();
                        ParameterObjectValue.Builder childBuilder = ElementDeclarer.newObjectValue().ofType(child.getIdentifier());
                        this.cloneAsDeclaration((ConfigLine)child, childBuilder);
                        reconnection.withParameter(paramName, childBuilder.build());
                    });
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup("Connection").withParameter("reconnection", reconnection.build()).getDeclaration());
                });
                return;
            }
            case "reconnectionStrategy": {
                this.findAnyMatchingChildById(declaredConfigs, "reconnect", "reconnect-forever").ifPresent(config -> {
                    ParameterObjectValue.Builder reconnection = ElementDeclarer.newObjectValue().ofType(config.getIdentifier());
                    this.copyExplicitAttributes(config.getConfigAttributes(), reconnection);
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup("Connection").withParameter("reconnectionStrategy", reconnection.build()).getDeclaration());
                });
                return;
            }
            case "redeliveryPolicy": {
                this.findAnyMatchingChildById(declaredConfigs, "redelivery-policy").ifPresent(config -> {
                    ParameterObjectValue.Builder redelivery = ElementDeclarer.newObjectValue();
                    this.copyExplicitAttributes(config.getConfigAttributes(), redelivery);
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("redeliveryPolicy", redelivery.build()).getDeclaration());
                });
                return;
            }
            case "expirationPolicy": {
                this.findAnyMatchingChildById(declaredConfigs, "expiration-policy").ifPresent(config -> {
                    ParameterObjectValue.Builder expiration = ElementDeclarer.newObjectValue();
                    this.copyExplicitAttributes(config.getConfigAttributes(), expiration);
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("expirationPolicy", expiration.build()).getDeclaration());
                });
                return;
            }
            case "poolingProfile": {
                this.findAnyMatchingChildById(declaredConfigs, "pooling-profile").ifPresent(config -> {
                    ParameterObjectValue.Builder poolingProfile = ElementDeclarer.newObjectValue();
                    this.cloneAsDeclaration((ConfigLine)config, poolingProfile);
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup("Connection").withParameter("poolingProfile", poolingProfile.build()).getDeclaration());
                });
                return;
            }
            case "streamingStrategy": {
                this.findAnyMatchingChildById(declaredConfigs, "repeatable-file-store-stream", "repeatable-in-memory-stream", "non-repeatable-stream").ifPresent(config -> {
                    ParameterObjectValue.Builder streaming = ElementDeclarer.newObjectValue().ofType(config.getIdentifier());
                    this.cloneAsDeclaration((ConfigLine)config, streaming);
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("streamingStrategy", streaming.build()).getDeclaration());
                });
                return;
            }
            case "tlsContext": {
                this.findAnyMatchingChildById(declaredConfigs, "context").ifPresent(config -> {
                    ParameterObjectValue.Builder tls = ElementDeclarer.newObjectValue();
                    this.cloneAsDeclaration((ConfigLine)config, tls);
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("tlsContext", tls.build()).getDeclaration());
                });
                return;
            }
        }
    }

    private Optional<ConfigLine> findAnyMatchingChildById(List<ConfigLine> configs, String ... validIds) {
        List<String> ids = Arrays.asList(validIds);
        return configs.stream().filter(c -> ids.contains(c.getIdentifier())).findFirst();
    }

    private void cloneAsDeclaration(ConfigLine config, ParameterObjectValue.Builder poolingProfile) {
        this.copyExplicitAttributes(config.getConfigAttributes(), poolingProfile);
        this.copyChildren(config, poolingProfile);
    }

    private String getNamespace(ConfigLine configLine) {
        return configLine.getNamespace() == null ? "mule" : configLine.getNamespace();
    }

    private void copyExplicitAttributes(Map<String, SimpleConfigAttribute> attributes, ParameterizedBuilder<String, ParameterValue, ?> builder) {
        attributes.values().stream().filter(a -> !a.getName().equals("name") && !a.getName().equals("config-ref")).filter(a -> !a.isValueFromSchema()).forEach(a -> builder.withParameter(a.getName(), ParameterSimpleValue.of(a.getValue())));
    }

    private void copyExplicitAttributes(ParameterizedModel model, Map<String, SimpleConfigAttribute> attributes, ParameterizedElementDeclarer builder) {
        attributes.values().stream().filter(a -> !a.getName().equals("name") && !a.getName().equals("config-ref")).filter(a -> !a.isValueFromSchema()).forEach(a -> {
            Optional<ParameterGroupModel> ownerGroup = model.getParameterGroupModels().stream().filter(group -> group.getParameter(a.getName()).isPresent()).findFirst();
            if (ownerGroup.isPresent()) {
                builder.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup(ownerGroup.get().getName()).withParameter(a.getName(), ParameterSimpleValue.of(a.getValue())).getDeclaration());
            } else {
                builder.withCustomParameter(a.getName(), a.getValue());
            }
        });
    }

    private void copyChildren(ConfigLine config, ParameterizedBuilder<String, ParameterValue, ?> builder) {
        config.getChildren().forEach(child -> {
            ParameterObjectValue.Builder childBuilder = ElementDeclarer.newObjectValue();
            this.cloneAsDeclaration((ConfigLine)child, childBuilder);
            builder.withParameter(child.getIdentifier(), childBuilder.build());
        });
    }
}

