/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model.config;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.internal.dsl.model.config.ConfigurationPropertiesException;
import org.mule.runtime.config.internal.dsl.model.config.ConfigurationPropertiesProvider;
import org.mule.runtime.config.internal.dsl.model.config.ConfigurationProperty;
import org.yaml.snakeyaml.Yaml;

public class ConfigurationPropertiesComponent
extends AbstractComponent
implements ConfigurationPropertiesProvider,
Initialisable {
    private static final String PROPERTIES_EXTENSION = ".properties";
    private static final String YAML_EXTENSION = ".yaml";
    private static final String UNKNOWN = "unknown";
    private final Map<String, ConfigurationProperty> configurationAttributes = new HashMap<String, ConfigurationProperty>();
    private String fileLocation;
    private ResourceProvider resourceProvider;

    public ConfigurationPropertiesComponent(String fileLocation, ResourceProvider resourceProvider) throws ConfigurationPropertiesException {
        this.fileLocation = fileLocation;
        this.resourceProvider = resourceProvider;
    }

    @Override
    public Optional<ConfigurationProperty> getConfigurationProperty(String configurationAttributeKey) {
        return Optional.ofNullable(this.configurationAttributes.get(configurationAttributeKey));
    }

    @Override
    public String getDescription() {
        ComponentLocation location = (ComponentLocation)this.getAnnotation(LOCATION_KEY);
        return String.format("<configuration-attributes file=\"%s\"> - file: %s, line number: %s", this.fileLocation, location.getFileName().orElse(UNKNOWN), location.getLineInFile().map(String::valueOf).orElse(UNKNOWN));
    }

    @Override
    public void initialise() throws InitialisationException {
        if (!this.fileLocation.endsWith(PROPERTIES_EXTENSION) && !this.fileLocation.endsWith(YAML_EXTENSION)) {
            throw new ConfigurationPropertiesException(I18nMessageFactory.createStaticMessage(String.format("Configuration properties file %s must end with yaml or properties extension", this.fileLocation)), this);
        }
        try (InputStream is = this.resourceProvider.getResourceAsStream(this.fileLocation);){
            if (is == null) {
                throw new ConfigurationPropertiesException(I18nMessageFactory.createStaticMessage(String.format("Couldn't find configuration properties file %s neither on classpath or in file system", this.fileLocation)), this);
            }
            if (this.fileLocation.endsWith(PROPERTIES_EXTENSION)) {
                Properties properties = new Properties();
                properties.load(is);
                properties.keySet().stream().map(key -> {
                    Object rawValue = properties.get(key);
                    return new ConfigurationProperty(Optional.of(this), (String)key, (String)rawValue);
                }).forEach(configurationAttribute -> this.configurationAttributes.put(configurationAttribute.getKey(), (ConfigurationProperty)configurationAttribute));
            } else {
                Yaml yaml = new Yaml();
                Iterable yamlObjects = yaml.loadAll(is);
                yamlObjects.forEach(yamlObject -> this.createAttributesFromYamlObject(null, null, yamlObject));
            }
        }
        catch (ConfigurationPropertiesException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationPropertiesException(I18nMessageFactory.createStaticMessage("Couldn't read from file " + this.fileLocation), this, e);
        }
    }

    private void createAttributesFromYamlObject(String parentPath, Object parentYamlObject, Object yamlObject) {
        if (yamlObject instanceof List) {
            List list = (List)yamlObject;
            if (list.get(0) instanceof Map) {
                list.forEach(value -> this.createAttributesFromYamlObject(parentPath, yamlObject, value));
            } else {
                if (!(list.get(0) instanceof String)) {
                    throw new ConfigurationPropertiesException(I18nMessageFactory.createStaticMessage("List of complex objects are not supported as property values. Offending key is " + parentPath), this);
                }
                String[] values = new String[list.size()];
                list.toArray(values);
                String value2 = String.join((CharSequence)",", list);
                this.configurationAttributes.put(parentPath, new ConfigurationProperty(this, parentPath, value2));
            }
        } else if (yamlObject instanceof Map) {
            if (parentYamlObject instanceof List) {
                throw new ConfigurationPropertiesException(I18nMessageFactory.createStaticMessage("Configuration properties does not support type a list of complex types. Complex type keys are: " + String.join((CharSequence)",", ((Map)yamlObject).keySet())), this);
            }
            Map map = (Map)yamlObject;
            map.entrySet().stream().forEach(entry -> this.createAttributesFromYamlObject(this.createKey(parentPath, (String)entry.getKey()), yamlObject, entry.getValue()));
        } else {
            if (!(yamlObject instanceof String)) {
                throw new ConfigurationPropertiesException(I18nMessageFactory.createStaticMessage(String.format("YAML configuration properties only supports string values, make sure to wrap the value with \" so you force the value to be an string. Offending property is %s with value %s", parentPath, yamlObject)), this);
            }
            this.configurationAttributes.put(parentPath, new ConfigurationProperty(this, parentPath, yamlObject));
        }
    }

    private String createKey(String parentKey, String key) {
        if (parentKey == null) {
            return key;
        }
        return parentKey + "." + key;
    }
}

