/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.processor.ObjectTypeVisitor;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.config.internal.dsl.spring.MapFactoryBean;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.springframework.AAA.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.AAA.beans.factory.support.ManagedList;

class MapBeanDefinitionCreator
extends BeanDefinitionCreator {
    MapBeanDefinitionCreator() {
    }

    @Override
    boolean handleRequest(CreateBeanDefinitionRequest createBeanDefinitionRequest) {
        SpringComponentModel componentModel = createBeanDefinitionRequest.getComponentModel();
        ObjectTypeVisitor objectTypeVisitor = new ObjectTypeVisitor(componentModel);
        ComponentBuildingDefinition componentBuildingDefinition = createBeanDefinitionRequest.getComponentBuildingDefinition();
        componentBuildingDefinition.getTypeDefinition().visit(objectTypeVisitor);
        Class<?> type = objectTypeVisitor.getType();
        if (Map.class.isAssignableFrom(type) && componentBuildingDefinition.getObjectFactoryType() == null) {
            ManagedList managedList = componentModel.getInnerComponents().stream().map(c -> ((SpringComponentModel)c).getBeanDefinition()).collect(Collectors.toCollection(ManagedList::new));
            componentModel.setBeanDefinition(BeanDefinitionBuilder.genericBeanDefinition(MapFactoryBean.class).addConstructorArgValue(managedList).addConstructorArgValue(type).getBeanDefinition());
            return true;
        }
        return false;
    }
}

