/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import java.util.HashMap;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.springframework.AAA.beans.factory.config.RuntimeBeanReference;
import org.springframework.AAA.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.AAA.beans.factory.support.ManagedList;
import org.springframework.AAA.beans.factory.support.ManagedMap;

class PropertiesMapBeanDefinitionCreator
extends BeanDefinitionCreator {
    PropertiesMapBeanDefinitionCreator() {
    }

    @Override
    boolean handleRequest(CreateBeanDefinitionRequest createBeanDefinitionRequest) {
        SpringComponentModel componentModel = createBeanDefinitionRequest.getComponentModel();
        if (componentModel.getIdentifier().equals(ApplicationModel.MULE_PROPERTIES_IDENTIFIER) || componentModel.getIdentifier().equals(ApplicationModel.MULE_PROPERTY_IDENTIFIER)) {
            ManagedMap<Object, Object> managedMap;
            if (componentModel.getIdentifier().equals(ApplicationModel.MULE_PROPERTIES_IDENTIFIER)) {
                managedMap = this.createManagedMapFromEntries(componentModel);
            } else {
                managedMap = new ManagedMap();
                ComponentModel parentComponentModel = componentModel.getParent();
                parentComponentModel.getInnerComponents().stream().filter(childComponentModel -> childComponentModel.getIdentifier().equals(ApplicationModel.MULE_PROPERTY_IDENTIFIER)).forEach(childComponentModel -> this.processAndAddMapProperty((ComponentModel)childComponentModel, managedMap));
            }
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(HashMap.class);
            componentModel.setBeanDefinition(beanDefinitionBuilder.addConstructorArgValue(managedMap).getBeanDefinition());
            return true;
        }
        return false;
    }

    private ManagedMap<Object, Object> createManagedMapFromEntries(ComponentModel componentModel) {
        ManagedMap<Object, Object> managedMap = new ManagedMap<Object, Object>();
        for (ComponentModel innerComponent : componentModel.getInnerComponents()) {
            this.processAndAddMapProperty(innerComponent, managedMap);
        }
        return managedMap;
    }

    private void processAndAddMapProperty(ComponentModel componentModel, ManagedMap<Object, Object> managedMap) {
        Object key = this.resolveValue(componentModel.getParameters().get("key"), componentModel.getParameters().get("key-ref"));
        Object value = this.resolveValue(componentModel.getParameters().get("value"), componentModel.getParameters().get("value-ref"));
        if (value == null) {
            value = this.resolveValueFromChild(componentModel.getInnerComponents().get(0));
        }
        managedMap.put(key, value);
    }

    private Object resolveValueFromChild(ComponentModel componentModel) {
        if (componentModel.getIdentifier().getName().equals("map")) {
            return this.createManagedMapFromEntries(componentModel);
        }
        return this.createManagedListFromItems(componentModel);
    }

    private Object createManagedListFromItems(ComponentModel componentModel) {
        ManagedList managedList = new ManagedList();
        componentModel.getInnerComponents().forEach(childComponent -> {
            if (childComponent.getIdentifier().getName().equals("value")) {
                managedList.add(childComponent.getTextContent());
            } else {
                managedList.add(new RuntimeBeanReference(childComponent.getParameters().get("bean")));
            }
        });
        return managedList;
    }

    private Object resolveValue(String value, String reference) {
        if (reference != null) {
            return new RuntimeBeanReference(reference);
        }
        return value;
    }
}

